/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternComponent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.patternsviewer.PatternLeaf;
import org.eclipse.jface.viewers.CheckboxTreeViewer;

public class PatternComposite
extends PatternComponent {
    protected List<PatternComponent> children;
    private Map<String, PatternComposite> fragmentMap;

    public PatternComposite(String patternNameFragment, PatternComposite parent) {
        this.patternNameFragment = patternNameFragment;
        this.children = new ArrayList<PatternComponent>();
        this.fragmentMap = new HashMap<String, PatternComposite>();
        this.parent = parent;
    }

    public List<PatternComponent> find(String patternFragment) {
        ArrayList<PatternComponent> components = new ArrayList<PatternComponent>();
        this.find(patternFragment, components);
        return components;
    }

    public PatternComposite getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    private void find(String patternFragment, List<PatternComponent> components) {
        String[] tokens = patternFragment.split("\\.");
        if (tokens.length == 1) {
            for (PatternComponent pc : this.children) {
                if (!pc.getPatternNameFragment().matches(patternFragment)) continue;
                components.add(pc);
            }
        } else {
            String prefix = tokens[0];
            String suffix = patternFragment.substring(prefix.length() + 1);
            PatternComposite composite = this.fragmentMap.get(prefix);
            if (composite != null) {
                components.add(composite);
                composite.find(suffix, components);
            }
        }
    }

    public PatternComponent addComponent(String patternFragment) {
        String[] tokens = patternFragment.split("\\.");
        if (tokens.length == 1) {
            PatternLeaf leaf = new PatternLeaf(patternFragment, this);
            leaf.setSelected(true);
            this.children.add(leaf);
            return leaf;
        }
        String prefix = tokens[0];
        String suffix = patternFragment.substring(prefix.length() + 1);
        PatternComposite composite = this.fragmentMap.get(prefix);
        if (composite == null) {
            composite = new PatternComposite(prefix, this);
            this.fragmentMap.put(prefix, composite);
            this.children.add(composite);
        }
        return composite.addComponent(suffix);
    }

    public List<PatternLeaf> getAllLeaves() {
        ArrayList<PatternLeaf> leaves = new ArrayList<PatternLeaf>();
        for (PatternComponent component : this.children) {
            if (component instanceof PatternLeaf) {
                leaves.add((PatternLeaf)component);
                continue;
            }
            leaves.addAll(((PatternComposite)component).getAllLeaves());
        }
        return leaves;
    }

    public List<PatternLeaf> getDirectLeaves() {
        ArrayList<PatternLeaf> leaves = new ArrayList<PatternLeaf>();
        for (PatternComponent component : this.children) {
            if (!(component instanceof PatternLeaf)) continue;
            leaves.add((PatternLeaf)component);
        }
        return leaves;
    }

    public void purge() {
        ArrayList<PatternComponent> copyOfChildren = new ArrayList<PatternComponent>(this.children);
        for (PatternComponent component : copyOfChildren) {
            if (!(component instanceof PatternComposite)) continue;
            PatternComposite composite = (PatternComposite)component;
            composite.purge();
        }
        if (this.getAllLeaves().size() == 0) {
            QueryExplorer.getInstance().getPatternsViewerInput().getGenericPatternsRoot().removeComponent(this.getFullPatternNamePrefix());
        }
    }

    public List<PatternComponent> getAllChildren() {
        ArrayList<PatternComponent> result = new ArrayList<PatternComponent>(this.children);
        for (PatternComponent component : this.children) {
            if (!(component instanceof PatternComposite)) continue;
            result.addAll(((PatternComposite)component).getAllChildren());
        }
        return result;
    }

    public void propagateDeSelectionToTop() {
        QueryExplorer.getInstance().getPatternsViewer().setChecked((Object)this, false);
        this.setSelected(false);
        if (this.parent != null) {
            this.parent.propagateDeSelectionToTop();
        }
    }

    public void propagateSelectionToTop(PatternComponent selected) {
        boolean allSelected = true;
        for (PatternComponent component : this.children) {
            if (component == selected || QueryExplorer.getInstance().getPatternsViewer().getChecked((Object)component)) continue;
            allSelected = false;
        }
        if (allSelected) {
            QueryExplorer.getInstance().getPatternsViewer().setChecked((Object)this, true);
            this.setSelected(true);
            if (this.parent != null) {
                this.parent.propagateSelectionToTop(this);
            }
        }
    }

    public void removeComponent(String patternFragment) {
        String[] tokens = patternFragment.split("\\.");
        if (tokens.length == 1) {
            PatternComponent component = null;
            for (PatternComponent c : this.children) {
                if (!c.getPatternNameFragment().matches(patternFragment)) continue;
                component = c;
            }
            if (component != null) {
                this.children.remove(component);
                this.fragmentMap.remove(patternFragment);
            }
        } else {
            String prefix = tokens[0];
            String suffix = patternFragment.substring(prefix.length() + 1);
            PatternComposite composite = this.fragmentMap.get(prefix);
            if (composite != null) {
                composite.removeComponent(suffix);
            }
        }
    }

    public List<PatternComponent> getDirectChildren() {
        return this.children;
    }

    @Override
    public String getFullPatternNamePrefix() {
        StringBuilder sb = new StringBuilder(this.patternNameFragment);
        if (this.parent != null && this.parent.getParent() != null) {
            sb.insert(0, ".");
            sb.insert(0, this.parent.getFullPatternNamePrefix());
        }
        return sb.toString();
    }

    @Override
    public boolean updateSelection(CheckboxTreeViewer treeViewer) {
        boolean allSelected = this.children.size() > 0;
        for (PatternComponent pc : this.children) {
            if (pc.updateSelection(treeViewer)) continue;
            allSelected = false;
        }
        treeViewer.setChecked((Object)this, allSelected);
        return allSelected;
    }

    public int hashCode() {
        int hash = this.patternNameFragment.hashCode();
        for (PatternComponent pc : this.children) {
            hash += 31 * pc.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PatternComposite composite = (PatternComposite)obj;
        return this.patternNameFragment == composite.patternNameFragment && this.parent == composite.parent && this.children.equals(composite.children);
    }
}

