/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.sources;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.incquery.databinding.runtime.observables.ObservableLabelFeature;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class QueryLabelProvider
extends LabelProvider {
    private IChangeListener changeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            Object container = ((ObservableLabelFeature)event.getSource()).getContainer();
            LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)QueryLabelProvider.this, container);
            QueryLabelProvider.this.fireLabelProviderChanged(newEvent);
        }
    };
    private List<IObservableValue> observables = Lists.newArrayList();

    public String getText(Object element) {
        if (element instanceof Item) {
            IObservableValue value = ((Item)element).getLabel();
            value.addChangeListener(this.changeListener);
            this.observables.add(value);
            return value.getValue().toString();
        }
        if (element instanceof Edge) {
            IObservableValue value = ((Edge)element).getLabel();
            value.addChangeListener(this.changeListener);
            this.observables.add(value);
            return value.getValue().toString();
        }
        return "";
    }

    public void dispose() {
        for (IObservableValue value : this.observables) {
            if (value == null || value.isDisposed()) continue;
            value.removeChangeListener(this.changeListener);
        }
        super.dispose();
    }
}

