/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.quickfix;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.incquery.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

public class EMFPatternLanguageQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.identifier_as_keyword")
    public void escapeKeywordAsIdentifier(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Prefix Identifier", "Adds a ^ prefix to the identifier", null, new IModification(){

            public void apply(IModificationContext context) throws Exception {
                IXtextDocument document = context.getXtextDocument();
                document.replace(issue.getOffset().intValue(), 0, "^");
            }
        });
    }

    @Fix(value="org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_import_dependency")
    public void addDependency(final Issue issue, IssueResolutionAcceptor acceptor) {
        acceptor.accept(issue, "Add dependency", "Add the required bundle to the manifest.mf file.", null, new IModification(){

            public void apply(IModificationContext context) throws CoreException, BadLocationException {
                URI uriToProblem = issue.getUriToProblem();
                if (uriToProblem.isPlatform()) {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile file = root.getFile((IPath)new Path(uriToProblem.toPlatformString(true)));
                    if (file.exists() && !file.isReadOnly()) {
                        ProjectGenerationHelper.ensureBundleDependencies((IProject)file.getProject(), Arrays.asList(issue.getData()));
                    }
                    IXtextDocument document = context.getXtextDocument();
                    document.replace(issue.getOffset().intValue(), 1, document.get(issue.getOffset().intValue(), 1));
                }
            }
        });
    }
}

