package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.TypePackageMatch;
import org.eclipse.uml2.uml.Type;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.typePackage pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class TypePackageProcessor implements IMatchProcessor<TypePackageMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final Type pSource, final org.eclipse.uml2.uml.Package pTarget);
  
  @Override
  public void process(final TypePackageMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
