/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.quasitree;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.incquery.runtime.base.api.FunctionalDependencyHelper;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;

class JoinCandidate<StubHandle> {
    Stub<StubHandle> primary;
    Stub<StubHandle> secondary;
    Set<PVariable> varPrimary;
    Set<PVariable> varSecondary;
    Set<PVariable> varCommon;
    private Boolean heath;

    JoinCandidate(Stub<StubHandle> primary, Stub<StubHandle> secondary) {
        this.primary = primary;
        this.secondary = secondary;
        this.varPrimary = this.getPrimary().getVariablesSet();
        this.varSecondary = this.getSecondary().getVariablesSet();
        this.varCommon = CollectionsFactory.getSet(this.varPrimary);
        this.varCommon.retainAll(this.varSecondary);
    }

    public Stub<StubHandle> getPrimary() {
        return this.primary;
    }

    public Stub<StubHandle> getSecondary() {
        return this.secondary;
    }

    public String toString() {
        return String.valueOf(this.primary.toString()) + " |x| " + this.secondary.toString();
    }

    public Set<PVariable> getVarPrimary() {
        return this.varPrimary;
    }

    public Set<PVariable> getVarSecondary() {
        return this.varSecondary;
    }

    public boolean isTrivial() {
        return this.getPrimary().equals(this.getSecondary());
    }

    public boolean isCheckOnly() {
        return this.varPrimary.containsAll(this.varSecondary) || this.varSecondary.containsAll(this.varPrimary);
    }

    public boolean isDescartes() {
        return Collections.disjoint(this.varPrimary, this.varSecondary);
    }

    public boolean isHeath() {
        if (this.heath == null) {
            HashMap<Set<PVariable>, Set<PVariable>> dependencies = new HashMap<Set<PVariable>, Set<PVariable>>();
            for (PConstraint pConstraint : this.primary.getAllEnforcedConstraints()) {
                dependencies.putAll(pConstraint.getFunctionalDependencies());
            }
            for (PConstraint pConstraint : this.secondary.getAllEnforcedConstraints()) {
                dependencies.putAll(pConstraint.getFunctionalDependencies());
            }
            Set varCommonClosure = FunctionalDependencyHelper.closureOf(this.varCommon, dependencies);
            this.heath = varCommonClosure.containsAll(this.varPrimary) || varCommonClosure.containsAll(this.varSecondary);
        }
        return this.heath;
    }
}

