/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicdeferred;

import java.util.Collections;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.planning.QueryPlannerException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.VariableDeferredPConstraint;

public class ExportedParameter
extends VariableDeferredPConstraint {
    PVariable parameterVariable;
    String parameterName;

    public ExportedParameter(PBody pSystem, PVariable parameterVariable, String parameterName) {
        super(pSystem, Collections.singleton(parameterVariable));
        this.parameterVariable = parameterVariable;
        this.parameterName = parameterVariable.getName();
    }

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (obsolete.equals(this.parameterVariable)) {
            this.parameterVariable = replacement;
        }
    }

    @Override
    protected String toStringRest() {
        String varName = this.parameterVariable.getName();
        return this.parameterName.equals(varName) ? this.parameterName : String.valueOf(this.parameterName) + "(" + varName + ")";
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return Collections.emptySet();
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public PVariable getParameterVariable() {
        return this.parameterVariable;
    }

    @Override
    public Set<PVariable> getDeferringVariables() {
        return Collections.singleton(this.parameterVariable);
    }

    @Override
    public void checkSanity() throws QueryPlannerException {
        super.checkSanity();
        if (!this.parameterVariable.isDeducable()) {
            String[] args = new String[]{this.parameterName};
            String msg = "Impossible to match pattern: exported pattern variable {1} can not be determined based on the pattern constraints. HINT: certain constructs (e.g. negative patterns or check expressions) cannot output symbolic parameters.";
            String shortMsg = "Could not deduce value of parameter";
            throw new QueryPlannerException(msg, args, shortMsg, null);
        }
    }
}

