package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.PackageVisibleMemberMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageVisibleMemberQuerySpecification;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.packageVisibleMember pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link PackageVisibleMemberMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (member-{@literal >}select( m | m.oclIsKindOf(PackageableElement) and self.makesVisible(m))-{@literal >}collect(oclAsType(PackageableElement))-{@literal >}asSet())
 * 
 * pattern packageVisibleMember(package_: Package, visibleMember: PackageableElement) {
 * 	find packageDirectlyVisibleMember(package_, visibleMember);
 * } or {
 * 	find packageAllImportedPackages(package_, importedPackage);
 * 	find packageDirectlyVisibleMember(importedPackage, visibleMember);
 * }
 * </pre></code>
 * 
 * @see PackageVisibleMemberMatch
 * @see PackageVisibleMemberProcessor
 * @see PackageVisibleMemberQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class PackageVisibleMemberMatcher extends BaseMatcher<PackageVisibleMemberMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static PackageVisibleMemberMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    PackageVisibleMemberMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new PackageVisibleMemberMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_PACKAGE_ = 0;
  
  private final static int POSITION_VISIBLEMEMBER = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(PackageVisibleMemberMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public PackageVisibleMemberMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public PackageVisibleMemberMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @return matches represented as a PackageVisibleMemberMatch object.
   * 
   */
  public Collection<PackageVisibleMemberMatch> getAllMatches(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    return rawGetAllMatches(new Object[]{pPackage_, pVisibleMember});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @return a match represented as a PackageVisibleMemberMatch object, or null if no match is found.
   * 
   */
  public PackageVisibleMemberMatch getOneArbitraryMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    return rawGetOneArbitraryMatch(new Object[]{pPackage_, pVisibleMember});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    return rawHasMatch(new Object[]{pPackage_, pVisibleMember});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    return rawCountMatches(new Object[]{pPackage_, pVisibleMember});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember, final IMatchProcessor<? super PackageVisibleMemberMatch> processor) {
    rawForEachMatch(new Object[]{pPackage_, pVisibleMember}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember, final IMatchProcessor<? super PackageVisibleMemberMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pPackage_, pVisibleMember}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pPackage_ the fixed value of pattern parameter package_, or null if not bound.
   * @param pVisibleMember the fixed value of pattern parameter visibleMember, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public PackageVisibleMemberMatch newMatch(final org.eclipse.uml2.uml.Package pPackage_, final PackageableElement pVisibleMember) {
    return PackageVisibleMemberMatch.newMatch(pPackage_, pVisibleMember);
  }
  
  /**
   * Retrieve the set of values that occur in matches for package_.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<org.eclipse.uml2.uml.Package> rawAccumulateAllValuesOfpackage_(final Object[] parameters) {
    Set<org.eclipse.uml2.uml.Package> results = new HashSet<org.eclipse.uml2.uml.Package>();
    rawAccumulateAllValues(POSITION_PACKAGE_, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for package_.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<org.eclipse.uml2.uml.Package> getAllValuesOfpackage_() {
    return rawAccumulateAllValuesOfpackage_(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for package_.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<org.eclipse.uml2.uml.Package> getAllValuesOfpackage_(final PackageVisibleMemberMatch partialMatch) {
    return rawAccumulateAllValuesOfpackage_(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for package_.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<org.eclipse.uml2.uml.Package> getAllValuesOfpackage_(final PackageableElement pVisibleMember) {
    return rawAccumulateAllValuesOfpackage_(new Object[]{
    null, 
    pVisibleMember
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for visibleMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<PackageableElement> rawAccumulateAllValuesOfvisibleMember(final Object[] parameters) {
    Set<PackageableElement> results = new HashSet<PackageableElement>();
    rawAccumulateAllValues(POSITION_VISIBLEMEMBER, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for visibleMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfvisibleMember() {
    return rawAccumulateAllValuesOfvisibleMember(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for visibleMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfvisibleMember(final PackageVisibleMemberMatch partialMatch) {
    return rawAccumulateAllValuesOfvisibleMember(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for visibleMember.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<PackageableElement> getAllValuesOfvisibleMember(final org.eclipse.uml2.uml.Package pPackage_) {
    return rawAccumulateAllValuesOfvisibleMember(new Object[]{
    pPackage_, 
    null
    });
  }
  
  @Override
  protected PackageVisibleMemberMatch tupleToMatch(final Tuple t) {
    try {
    	return PackageVisibleMemberMatch.newMatch((org.eclipse.uml2.uml.Package) t.get(POSITION_PACKAGE_), (org.eclipse.uml2.uml.PackageableElement) t.get(POSITION_VISIBLEMEMBER));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected PackageVisibleMemberMatch arrayToMatch(final Object[] match) {
    try {
    	return PackageVisibleMemberMatch.newMatch((org.eclipse.uml2.uml.Package) match[POSITION_PACKAGE_], (org.eclipse.uml2.uml.PackageableElement) match[POSITION_VISIBLEMEMBER]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected PackageVisibleMemberMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return PackageVisibleMemberMatch.newMutableMatch((org.eclipse.uml2.uml.Package) match[POSITION_PACKAGE_], (org.eclipse.uml2.uml.PackageableElement) match[POSITION_VISIBLEMEMBER]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<PackageVisibleMemberMatcher> querySpecification() throws IncQueryException {
    return PackageVisibleMemberQuerySpecification.instance();
  }
}
