/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.tooling.ui.handlers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcherRoot;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.tooling.ui.views.ViewerSandboxView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class InitializeViewersHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            ObservablePatternMatcherRoot root = this.getSelectedMatcherRoot(selection);
            try {
                IEditingDomainProvider providerEditor;
                ResourceSet resourceSet;
                IEditorPart editorPart = root.getEditorPart();
                if (editorPart instanceof IEditingDomainProvider && (resourceSet = (providerEditor = (IEditingDomainProvider)editorPart).getEditingDomain().getResourceSet()).getResources().size() > 0) {
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                    for (ObservablePatternMatcher opm : root.getMatchers()) {
                        patterns.add(opm.getMatcher().getPattern());
                    }
                    if (ViewerSandboxView.getInstance() != null) {
                        ViewerDataFilter filter = this.prepareFilterInformation(root);
                        ViewerSandboxView.getInstance().setContents(resourceSet, patterns, filter);
                    }
                }
            }
            catch (IncQueryException e) {
                throw new ExecutionException("Error initializing pattern matcher.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ExecutionException("Invalid selrection", (Throwable)e);
            }
        }
        return null;
    }

    protected ObservablePatternMatcherRoot getSelectedMatcherRoot(ISelection selection) {
        Object firstElement = ((TreeSelection)selection).getFirstElement();
        if (firstElement instanceof ObservablePatternMatcherRoot) {
            return (ObservablePatternMatcherRoot)firstElement;
        }
        if (firstElement instanceof ObservablePatternMatcher) {
            return ((ObservablePatternMatcher)firstElement).getParent();
        }
        throw new IllegalArgumentException("Selection should contain an Pattern match from the query explorer");
    }

    protected ViewerDataFilter prepareFilterInformation(ObservablePatternMatcherRoot root) {
        ViewerDataFilter dataFilter = new ViewerDataFilter();
        for (ObservablePatternMatcher matcher : root.getMatchers()) {
            Object[] filter = matcher.getFilter();
            if (!Iterables.any(Arrays.asList(filter), (Predicate)Predicates.notNull())) continue;
            IPatternMatch filterMatch = matcher.getMatcher().newMatch(filter);
            dataFilter.addSingleFilter(matcher.getMatcher().getPattern(), filterMatch);
        }
        return dataFilter;
    }
}

