package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.FeatureFeaturingClassifierMatch;
import org.eclipse.incquery.uml.derivedfeatures.FeatureFeaturingClassifierMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassifierFeatureQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate FeatureFeaturingClassifierMatcher in a type-safe way.
 * 
 * @see FeatureFeaturingClassifierMatcher
 * @see FeatureFeaturingClassifierMatch
 * 
 */
@SuppressWarnings("all")
public final class FeatureFeaturingClassifierQuerySpecification extends BaseGeneratedEMFQuerySpecification<FeatureFeaturingClassifierMatcher> {
  private FeatureFeaturingClassifierQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static FeatureFeaturingClassifierQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected FeatureFeaturingClassifierMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return FeatureFeaturingClassifierMatcher.on(engine);
  }
  
  @Override
  public FeatureFeaturingClassifierMatch newEmptyMatch() {
    return FeatureFeaturingClassifierMatch.newEmptyMatch();
  }
  
  @Override
  public FeatureFeaturingClassifierMatch newMatch(final Object... parameters) {
    return FeatureFeaturingClassifierMatch.newMatch((org.eclipse.uml2.uml.Feature) parameters[0], (org.eclipse.uml2.uml.Classifier) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static FeatureFeaturingClassifierQuerySpecification INSTANCE = make();
    
    public static FeatureFeaturingClassifierQuerySpecification make() {
      return new FeatureFeaturingClassifierQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static FeatureFeaturingClassifierQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.featureFeaturingClassifier";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("source", "org.eclipse.uml2.uml.Feature"),new PParameter("target", "org.eclipse.uml2.uml.Classifier"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		new TypeConstraint(body, new FlatTuple(var_source), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Feature")));
      		new TypeConstraint(body, new FlatTuple(var_target), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Classifier")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_target, "target")
      		));
      		//     // opposite of Classifier.feature    find classifierFeature(target, source)
      		new PositivePatternCall(body, new FlatTuple(var_target, var_source), ClassifierFeatureQuerySpecification.instance().getInternalQueryRepresentation());
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("Surrogate");
      		annotation.addAttribute("feature", "featuringClassifier");
      		addAnnotation(annotation);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
