/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.retevis.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcherRoot;
import org.eclipse.incquery.tooling.ui.retevis.views.ReteVisView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class InitializeRetevisHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ObservablePatternMatcherRoot root;
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection && (root = this.getSelectedMatcherRoot(selection)).getMatchers() != null && root.getMatchers().size() > 0) {
            try {
                ObservablePatternMatcher pm = (ObservablePatternMatcher)root.getMatchers().get(0);
                ReteBoundary rb = ((AdvancedIncQueryEngine)pm.getMatcher().getEngine()).getReteEngine().getBoundary();
                ReteVisView.getInstance().setContent(rb);
            }
            catch (IncQueryException e) {
                throw new ExecutionException("Error initializing pattern matcher.", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ExecutionException("Invalid selrection", (Throwable)e);
            }
        }
        return null;
    }

    protected ObservablePatternMatcherRoot getSelectedMatcherRoot(ISelection selection) {
        Object firstElement = ((TreeSelection)selection).getFirstElement();
        if (firstElement instanceof ObservablePatternMatcherRoot) {
            return (ObservablePatternMatcherRoot)firstElement;
        }
        if (firstElement instanceof ObservablePatternMatcher) {
            return ((ObservablePatternMatcher)firstElement).getParent();
        }
        throw new IllegalArgumentException("Selection should contain an Pattern match from the query explorer");
    }
}

