/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.debug.common;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public abstract class VariablesFactory {
    public abstract List<IJavaVariable> getVariables(JDIStackFrame var1, ThreadReference var2);

    public VirtualMachine getVirtualMachine(JDIStackFrame wrappedStackFrame) {
        try {
            JDIObjectValue classLoaderObject = (JDIObjectValue)wrappedStackFrame.getReferenceType().getClassLoaderObject();
            if (classLoaderObject != null) {
                ClassLoaderReference classLoaderReference = (ClassLoaderReference)classLoaderObject.getUnderlyingObject();
                return classLoaderReference.virtualMachine();
            }
        }
        catch (DebugException e) {
            IncQueryLoggingUtil.getLogger(VariablesFactory.class).error((Object)"Couldn't retrieve the virtual machine instance!", (Throwable)e);
            return null;
        }
        return null;
    }
}

