/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.engine;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IMatchUpdateListener;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryEngineLifecycleListener;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener;
import org.eclipse.incquery.runtime.base.api.IncQueryBaseIndexChangeListener;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.internal.engine.ListenerContainer;

public final class ModelUpdateProvider
extends ListenerContainer<IncQueryModelUpdateListener> {
    private final AdvancedIncQueryEngine incQueryEngine;
    private IncQueryModelUpdateListener.ChangeLevel currentChange = IncQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
    private IncQueryModelUpdateListener.ChangeLevel maxLevel = IncQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
    private final Multimap<IncQueryModelUpdateListener.ChangeLevel, IncQueryModelUpdateListener> listenerMap;
    private final Logger logger;
    private final IncQueryBaseIndexChangeListener indexListener = new IncQueryBaseIndexChangeListener(){

        public boolean onlyOnIndexChange() {
            return false;
        }

        public void notifyChanged(boolean indexChanged) {
            if (indexChanged) {
                ModelUpdateProvider.this.currentChange = ModelUpdateProvider.this.currentChange.changeOccured(IncQueryModelUpdateListener.ChangeLevel.INDEX);
            } else {
                ModelUpdateProvider.this.currentChange = ModelUpdateProvider.this.currentChange.changeOccured(IncQueryModelUpdateListener.ChangeLevel.MODEL);
            }
            ModelUpdateProvider.this.notifyListeners();
        }
    };
    private final IMatchUpdateListener<IPatternMatch> matchSetListener = new IMatchUpdateListener<IPatternMatch>(){

        @Override
        public void notifyDisappearance(IPatternMatch match) {
            ModelUpdateProvider.this.currentChange = ModelUpdateProvider.this.currentChange.changeOccured(IncQueryModelUpdateListener.ChangeLevel.MATCHSET);
        }

        @Override
        public void notifyAppearance(IPatternMatch match) {
            ModelUpdateProvider.this.currentChange = ModelUpdateProvider.this.currentChange.changeOccured(IncQueryModelUpdateListener.ChangeLevel.MATCHSET);
        }
    };
    private final IncQueryEngineLifecycleListener selfListener = new IncQueryEngineLifecycleListener(){

        @Override
        public void matcherInstantiated(IncQueryMatcher<? extends IPatternMatch> matcher) {
            if (ModelUpdateProvider.this.maxLevel.compareTo(IncQueryModelUpdateListener.ChangeLevel.MATCHSET) >= 0) {
                ModelUpdateProvider.this.incQueryEngine.addMatchUpdateListener(matcher, ModelUpdateProvider.this.matchSetListener, false);
            }
        }

        @Override
        public void engineWiped() {
        }

        @Override
        public void engineDisposed() {
            ModelUpdateProvider.this.removeBaseIndexChangeListener();
            ModelUpdateProvider.this.listenerMap.clear();
            ModelUpdateProvider.this.maxLevel = IncQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
        }

        @Override
        public void engineBecameTainted(String description, Throwable t) {
        }
    };

    public ModelUpdateProvider(AdvancedIncQueryEngine incQueryEngine, Logger logger) {
        this.incQueryEngine = incQueryEngine;
        this.logger = logger;
        EnumMap map = Maps.newEnumMap(IncQueryModelUpdateListener.ChangeLevel.class);
        this.listenerMap = Multimaps.newSetMultimap((Map)map, (Supplier)new Supplier<Set<IncQueryModelUpdateListener>>(){

            public Set<IncQueryModelUpdateListener> get() {
                return Sets.newHashSet();
            }
        });
    }

    @Override
    protected void listenerAdded(IncQueryModelUpdateListener listener) {
        if (this.listenerMap.isEmpty()) {
            try {
                this.incQueryEngine.getBaseIndex().addBaseIndexChangeListener(this.indexListener);
                this.incQueryEngine.addLifecycleListener(this.selfListener);
            }
            catch (IncQueryException e) {
                throw new IllegalStateException("Model update listener used on engine without base index", e);
            }
        }
        IncQueryModelUpdateListener.ChangeLevel changeLevel = listener.getLevel();
        this.listenerMap.put((Object)changeLevel, (Object)listener);
        IncQueryModelUpdateListener.ChangeLevel oldMaxLevel = this.maxLevel;
        this.maxLevel = this.maxLevel.changeOccured(changeLevel);
        if (!this.maxLevel.equals((Object)oldMaxLevel) && IncQueryModelUpdateListener.ChangeLevel.MATCHSET.compareTo(oldMaxLevel) > 0 && IncQueryModelUpdateListener.ChangeLevel.MATCHSET.compareTo(this.maxLevel) <= 0) {
            for (IncQueryMatcher<? extends IPatternMatch> incQueryMatcher : this.incQueryEngine.getCurrentMatchers()) {
                this.incQueryEngine.addMatchUpdateListener(incQueryMatcher, this.matchSetListener, false);
            }
        }
    }

    @Override
    protected void listenerRemoved(IncQueryModelUpdateListener listener) {
        IncQueryModelUpdateListener.ChangeLevel changeLevel = listener.getLevel();
        boolean removed = this.listenerMap.remove((Object)changeLevel, (Object)listener);
        if (!removed) {
            this.handleUnsuccesfulRemove(listener);
        }
        this.updateMaxLevel();
        if (this.listenerMap.isEmpty()) {
            this.incQueryEngine.removeLifecycleListener(this.selfListener);
            this.removeBaseIndexChangeListener();
        }
    }

    private void removeBaseIndexChangeListener() {
        try {
            this.incQueryEngine.getBaseIndex().removeBaseIndexChangeListener(this.indexListener);
        }
        catch (IncQueryException e) {
            throw new IllegalStateException("Model update listener used on engine without base index", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateMaxLevel() {
        if (!this.listenerMap.containsKey((Object)this.maxLevel)) {
            void var1_2;
            IncQueryModelUpdateListener.ChangeLevel changeLevel = IncQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
            for (IncQueryModelUpdateListener.ChangeLevel level : ImmutableSet.copyOf((Collection)this.listenerMap.keySet())) {
                IncQueryModelUpdateListener.ChangeLevel changeLevel2 = var1_2.changeOccured(level);
            }
            this.maxLevel = var1_2;
        }
        if (this.maxLevel.compareTo(IncQueryModelUpdateListener.ChangeLevel.MATCHSET) < 0) {
            for (IncQueryMatcher<? extends IPatternMatch> incQueryMatcher : this.incQueryEngine.getCurrentMatchers()) {
                this.incQueryEngine.removeMatchUpdateListener(incQueryMatcher, this.matchSetListener);
            }
        }
    }

    private void handleUnsuccesfulRemove(IncQueryModelUpdateListener listener) {
        for (Map.Entry entry : this.listenerMap.entries()) {
            if (!((IncQueryModelUpdateListener)entry.getValue()).equals(listener)) continue;
            this.logger.error((Object)("Listener " + listener + " change level changed since initialization!"));
            this.listenerMap.remove(entry.getKey(), entry.getValue());
            return;
        }
        this.logger.error((Object)("Listener " + listener + " already removed from map (e.g. engine was already disposed)!"));
    }

    private void notifyListeners() {
        IncQueryModelUpdateListener.ChangeLevel tempLevel = this.currentChange;
        this.currentChange = IncQueryModelUpdateListener.ChangeLevel.NO_CHANGE;
        if (!this.listenerMap.isEmpty()) {
            for (IncQueryModelUpdateListener.ChangeLevel level : ImmutableSet.copyOf((Collection)this.listenerMap.keySet())) {
                if (tempLevel.compareTo(level) < 0) continue;
                for (IncQueryModelUpdateListener listener : new ArrayList(this.listenerMap.get((Object)level))) {
                    try {
                        listener.notifyChanged(tempLevel);
                    }
                    catch (Exception ex) {
                        this.logger.error((Object)("EMF-IncQuery encountered an error in delivering model update notification to listener " + listener + "."), (Throwable)ex);
                    }
                }
            }
        } else {
            throw new IllegalStateException("Notify listeners must not be called without listeners! Maybe an update callback was not removed correctly.");
        }
    }
}

