/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.operations.extend;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.incquery.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.incquery.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.incquery.runtime.localsearch.operations.IMatcherBasedOperation;
import org.eclipse.incquery.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public class CountOperation
extends ExtendOperation<Integer>
implements IMatcherBasedOperation {
    PQuery calledQuery;
    Map<Integer, Integer> frameMapping;
    private LocalSearchMatcher matcher;

    @Override
    public LocalSearchMatcher getAndPrepareCalledMatcher(MatchingFrame frame, ISearchContext context) {
        HashSet adornment = Sets.newHashSet();
        for (Map.Entry<Integer, Integer> mapping : this.frameMapping.entrySet()) {
            Integer source = mapping.getKey();
            if (frame.get(source) == null) continue;
            adornment.add(mapping.getValue());
        }
        this.matcher = context.getMatcher(new MatcherReference(this.calledQuery, adornment));
        return this.matcher;
    }

    @Override
    public LocalSearchMatcher getCalledMatcher() {
        return this.matcher;
    }

    public CountOperation(PQuery calledQuery, Map<Integer, Integer> frameMapping, int position) {
        super(position);
        this.calledQuery = calledQuery;
        this.frameMapping = frameMapping;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        this.getAndPrepareCalledMatcher(frame, context);
        MatchingFrame mappedFrame = this.matcher.editableMatchingFrame();
        for (Map.Entry<Integer, Integer> entry : this.frameMapping.entrySet()) {
            mappedFrame.setValue(entry.getValue(), frame.getValue(entry.getKey()));
        }
        this.it = Iterators.singletonIterator((Object)this.matcher.countMatches(mappedFrame));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CountOperation, pattern: ").append(this.calledQuery.getFullyQualifiedName().substring(this.calledQuery.getFullyQualifiedName().lastIndexOf(46) + 1));
        return builder.toString();
    }

    @Override
    public List<Integer> getVariablePositions() {
        ArrayList variables = Lists.newArrayList();
        variables.addAll(this.frameMapping.keySet());
        return variables;
    }
}

