package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.AssociationEndTypeMatch;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Type;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.associationEndType pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class AssociationEndTypeProcessor implements IMatchProcessor<AssociationEndTypeMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pType the value of pattern parameter type in the currently processed match
   * 
   */
  public abstract void process(final Association pSelf, final Type pType);
  
  @Override
  public void process(final AssociationEndTypeMatch match) {
    process(match.getSelf(), match.getType());
  }
}
