/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyPortFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class NetworkPolicyPortFluentImpl<A extends NetworkPolicyPortFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyPortFluent<A> {
    private Integer endPort;
    private IntOrStringBuilder port;
    private String protocol;
    private Map<String, Object> additionalProperties;

    public NetworkPolicyPortFluentImpl() {
    }

    public NetworkPolicyPortFluentImpl(NetworkPolicyPort instance) {
        if (instance != null) {
            this.withEndPort(instance.getEndPort());
            this.withPort(instance.getPort());
            this.withProtocol(instance.getProtocol());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Integer getEndPort() {
        return this.endPort;
    }

    @Override
    public A withEndPort(Integer endPort) {
        this.endPort = endPort;
        return (A)this;
    }

    @Override
    public Boolean hasEndPort() {
        return this.endPort != null;
    }

    @Override
    @Deprecated
    public IntOrString getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(IntOrString port) {
        this._visitables.get("port").remove(this.port);
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(Object value) {
        return this.withPort(new IntOrString(value));
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNestedImpl(item);
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new IntOrStringBuilder().build());
    }

    @Override
    public NetworkPolicyPortFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)this;
    }

    @Override
    public Boolean hasProtocol() {
        return this.protocol != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPortFluentImpl that = (NetworkPolicyPortFluentImpl)o;
        if (!Objects.equals(this.endPort, that.endPort)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.protocol, that.protocol)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.endPort, this.port, this.protocol, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endPort != null) {
            sb.append("endPort:");
            sb.append(this.endPort + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PortNestedImpl<N>
    extends IntOrStringFluentImpl<NetworkPolicyPortFluent.PortNested<N>>
    implements NetworkPolicyPortFluent.PortNested<N>,
    Nested<N> {
        IntOrStringBuilder builder;

        PortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPortFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

