/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.hono.util.TracingSamplingMode;

public class TenantTracingConfig {
    @JsonProperty(value="sampling-mode")
    private TracingSamplingMode samplingMode;
    @JsonProperty(value="sampling-mode-per-auth-id")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, TracingSamplingMode> samplingModePerAuthId = new HashMap<String, TracingSamplingMode>();

    public final TracingSamplingMode getSamplingMode() {
        return this.samplingMode;
    }

    public final TenantTracingConfig setSamplingMode(TracingSamplingMode samplingMode) {
        this.samplingMode = samplingMode;
        return this;
    }

    public Map<String, TracingSamplingMode> getSamplingModePerAuthId() {
        return Collections.unmodifiableMap(this.samplingModePerAuthId);
    }

    public TenantTracingConfig setSamplingModePerAuthId(Map<String, TracingSamplingMode> samplingModePerAuthId) {
        this.samplingModePerAuthId.clear();
        if (samplingModePerAuthId != null) {
            this.samplingModePerAuthId.putAll(samplingModePerAuthId);
        }
        return this;
    }

    @JsonIgnore
    public final TracingSamplingMode getSamplingMode(String authId) {
        if (authId == null) {
            return this.samplingMode;
        }
        return Optional.ofNullable(this.samplingModePerAuthId.get(authId)).orElse(this.samplingMode);
    }
}

