/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.producer;

import io.vertx.kafka.client.producer.KafkaProducer;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaProducerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaProducerHelper.class);

    private KafkaProducerHelper() {
    }

    public static void removeTopicMetrics(KafkaProducer<?, ?> kafkaProducer, Stream<String> topics) {
        Objects.requireNonNull(kafkaProducer);
        Objects.requireNonNull(topics);
        Metrics metrics = KafkaProducerHelper.getInternalMetricsObject(kafkaProducer.unwrap());
        if (metrics != null) {
            topics.forEach(topic -> {
                metrics.removeSensor("topic." + topic + ".records-per-batch");
                metrics.removeSensor("topic." + topic + ".bytes");
                metrics.removeSensor("topic." + topic + ".compression-rate");
                metrics.removeSensor("topic." + topic + ".record-retries");
                metrics.removeSensor("topic." + topic + ".record-errors");
            });
        }
    }

    private static Metrics getInternalMetricsObject(Producer<?, ?> producer) {
        if (producer instanceof org.apache.kafka.clients.producer.KafkaProducer) {
            try {
                Field field = org.apache.kafka.clients.producer.KafkaProducer.class.getDeclaredField("metrics");
                field.setAccessible(true);
                return (Metrics)field.get(producer);
            }
            catch (Exception e) {
                LOG.warn("failed to get metrics object", e);
            }
        }
        return null;
    }
}

