/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.vertx.core.spi.logging.LogDelegate;
import java.util.logging.LogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;

public class VertxLogDelegate
implements LogDelegate {
    private final Logger logger;

    public VertxLogDelegate(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.DEBUG);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.TRACE);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.FATAL, message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(Level.FATAL, message, t, new Object[0]);
    }

    @Override
    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    @Override
    public void error(Object message, Object ... params) {
        this.log(Level.ERROR, message, null, params);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.ERROR, message, t, new Object[0]);
    }

    @Override
    public void error(Object message, Throwable t, Object ... params) {
        this.log(Level.ERROR, message, t, params);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    @Override
    public void warn(Object message, Object ... params) {
        this.log(Level.WARN, message, null, params);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARN, message, t, new Object[0]);
    }

    @Override
    public void warn(Object message, Throwable t, Object ... params) {
        this.log(Level.WARN, message, t, params);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Object ... params) {
        this.log(Level.INFO, message, null, params);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t, new Object[0]);
    }

    @Override
    public void info(Object message, Throwable t, Object ... params) {
        this.log(Level.INFO, message, t, params);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    @Override
    public void debug(Object message, Object ... params) {
        this.log(Level.DEBUG, message, null, params);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Level.DEBUG, message, t, new Object[0]);
    }

    @Override
    public void debug(Object message, Throwable t, Object ... params) {
        this.log(Level.DEBUG, message, t, params);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.TRACE, message);
    }

    @Override
    public void trace(Object message, Object ... params) {
        this.log(Level.TRACE, message, null, params);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Level.TRACE, message, t, new Object[0]);
    }

    @Override
    public void trace(Object message, Throwable t, Object ... params) {
        this.log(Level.TRACE, message, t, params);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null, new Object[0]);
    }

    private void log(Level level, Object message, Throwable t, Object ... params) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        String msg = message == null ? "NULL" : message.toString();
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.logger.getName());
        if (t != null) {
            record.setThrown(t);
        } else if (params != null && params.length != 0 && params[params.length - 1] instanceof Throwable) {
            record.setThrown((Throwable)params[params.length - 1]);
        }
        record.setSourceClassName(null);
        record.setParameters(params);
        this.logger.log(record);
    }
}

