/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.file.AsyncFile;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.http.HttpServerFileUpload.class)
public class HttpServerFileUpload
implements ReadStream<Buffer> {
    public static final TypeArg<HttpServerFileUpload> __TYPE_ARG = new TypeArg<HttpServerFileUpload>(obj -> new HttpServerFileUpload((io.vertx.core.http.HttpServerFileUpload)obj), HttpServerFileUpload::getDelegate);
    private final io.vertx.core.http.HttpServerFileUpload delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg<Buffer>(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private Multi<Buffer> multi;

    public HttpServerFileUpload(io.vertx.core.http.HttpServerFileUpload delegate) {
        this.delegate = delegate;
    }

    public HttpServerFileUpload(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerFileUpload)delegate;
    }

    HttpServerFileUpload() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.http.HttpServerFileUpload getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerFileUpload that = (HttpServerFileUpload)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private HttpServerFileUpload __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public HttpServerFileUpload exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private HttpServerFileUpload __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    public HttpServerFileUpload handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Fluent
    private HttpServerFileUpload __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public HttpServerFileUpload endHandler(Runnable endHandler) {
        return this.__endHandler(ignored -> endHandler.run());
    }

    @Fluent
    public HttpServerFileUpload pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public HttpServerFileUpload resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    public HttpServerFileUpload fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> streamToFileSystem(String filename) {
        return AsyncResultUni.toUni(handler -> this.delegate.streamToFileSystem(filename, (Handler<AsyncResult<Void>>)handler));
    }

    public Void streamToFileSystemAndAwait(String filename) {
        return this.streamToFileSystem(filename).await().indefinitely();
    }

    public void streamToFileSystemAndForget(String filename) {
        this.streamToFileSystem(filename).subscribe().with(UniHelper.NOOP);
    }

    public boolean cancelStreamToFileSystem() {
        boolean ret = this.delegate.cancelStreamToFileSystem();
        return ret;
    }

    public String filename() {
        String ret = this.delegate.filename();
        return ret;
    }

    public String name() {
        String ret = this.delegate.name();
        return ret;
    }

    public String contentType() {
        String ret = this.delegate.contentType();
        return ret;
    }

    public String contentTransferEncoding() {
        String ret = this.delegate.contentTransferEncoding();
        return ret;
    }

    public String charset() {
        String ret = this.delegate.charset();
        return ret;
    }

    public long size() {
        long ret = this.delegate.size();
        return ret;
    }

    public boolean isSizeAvailable() {
        boolean ret = this.delegate.isSizeAvailable();
        return ret;
    }

    public AsyncFile file() {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.file());
        return ret;
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static HttpServerFileUpload newInstance(io.vertx.core.http.HttpServerFileUpload arg) {
        return arg != null ? new HttpServerFileUpload(arg) : null;
    }
}

