/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.ProxyReferenceTarget;

public class ProxyReferenceList {
    private final Object sourceNodeID;
    private final ProxyReferenceTarget targetFile;
    private final List<ProxyReference> references = new ArrayList<ProxyReference>();

    public static List<ProxyReferenceList> getLists(IGraphDatabase graph) throws Exception {
        return ProxyReferenceList.getLists(graph, "");
    }

    public static List<ProxyReferenceList> getLists(IGraphDatabase graph, String repositoryPrefix) throws Exception {
        HashSet<Object> visitedIDs = new HashSet<Object>();
        ArrayList<ProxyReferenceList> proxyReferenceLists = new ArrayList<ProxyReferenceList>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (IGraphTransaction tx = graph.beginTransaction();){
            IGraphNodeIndex proxyDictionary = graph.getOrCreateNodeIndex("proxydictionary");
            IGraphIterable proxies = proxyDictionary.query("hawkProxyRef:", (Object)(String.valueOf(repositoryPrefix) + "*"));
            for (IGraphNode n : proxies) {
                if (!visitedIDs.add(n.getId())) continue;
                ModelElementNode men = new ModelElementNode(n);
                proxyReferenceLists.addAll(men.getProxies());
            }
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return proxyReferenceLists;
    }

    public ProxyReferenceList(IGraphNode sourceNode, String[] rawValue) {
        this.sourceNodeID = sourceNode.getId();
        this.targetFile = new ProxyReferenceTarget(rawValue[0], true);
        int i = 0;
        while (i < rawValue.length) {
            ProxyReferenceTarget target = new ProxyReferenceTarget(rawValue[i], false);
            String edgeLabel = rawValue[i + 1];
            boolean isContainment = Boolean.valueOf(rawValue[i + 2]);
            boolean isContainer = Boolean.valueOf(rawValue[i + 3]);
            this.references.add(new ProxyReference(target, edgeLabel, isContainment, isContainer));
            i += 4;
        }
    }

    public String getFullPathURI() {
        return this.targetFile.getFileURI();
    }

    public String getRepositoryURL() {
        return this.targetFile.getRepositoryURL();
    }

    public String getFilePath() {
        return this.targetFile.getFilePath();
    }

    public ProxyReferenceTarget getTargetFile() {
        return this.targetFile;
    }

    public List<ProxyReference> getReferences() {
        return this.references;
    }

    public Object getSourceNodeID() {
        return this.sourceNodeID;
    }

    public String[] toArray() {
        String[] arr = new String[this.references.size() * 4];
        int i = 0;
        for (ProxyReference ref : this.references) {
            arr[i] = ref.getTarget().getElementURI();
            arr[i + 1] = ref.getEdgeLabel();
            arr[i + 2] = String.valueOf(ref.isContainment());
            arr[i + 3] = String.valueOf(ref.isContainer());
            i += 4;
        }
        return arr;
    }

    public String toString() {
        return "ProxyReferenceList [sourceNodeID=" + this.sourceNodeID + ", targetFile=" + this.targetFile + ", references=" + this.references + "]";
    }

    public class ProxyReference {
        private final ProxyReferenceTarget referenceTarget;
        private final String edgeLabel;
        private final boolean isContainment;
        private final boolean isContainer;

        public ProxyReference(ProxyReferenceTarget target, String edgeLabel, boolean isContainment, boolean isContainer) {
            this.referenceTarget = target;
            this.edgeLabel = edgeLabel;
            this.isContainment = isContainment;
            this.isContainer = isContainer;
        }

        public ProxyReferenceTarget getTarget() {
            return this.referenceTarget;
        }

        public String getEdgeLabel() {
            return this.edgeLabel;
        }

        public boolean isContainment() {
            return this.isContainment;
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public ProxyReferenceList getList() {
            return ProxyReferenceList.this;
        }

        public String toString() {
            return "ProxyReference [target=" + this.referenceTarget + ", edgeLabel=" + this.edgeLabel + ", isContainment=" + this.isContainment + ", isContainer=" + this.isContainer + "]";
        }
    }
}

