/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.workspace;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workspace
implements IVcsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(Workspace.class);
    private long revision;
    private boolean pendingChanges = false;
    private IConsole console;
    private WorkspaceListener listener;
    public static final String REPOSITORY_URL = "platform:/resource";
    private Set<IFile> previousFiles = new HashSet<IFile>();
    private Map<IFile, Long> recordedStamps = new HashMap<IFile, Long>();
    private boolean isFrozen = false;

    public String getFirstRevision() throws Exception {
        return "0";
    }

    public VcsRepositoryDelta getDelta(String sStartRevision, String endRevision) throws Exception {
        long startMillis = System.currentTimeMillis();
        ArrayList<VcsCommit> commits = new ArrayList<VcsCommit>();
        VcsRepositoryDelta delta = new VcsRepositoryDelta(commits);
        delta.setManager((IVcsManager)this);
        Set<IFile> files = this.getAllFiles();
        this.previousFiles.removeAll(files);
        for (IFile f : this.previousFiles) {
            this.addIFile(delta, commits, f, VcsChangeType.DELETED);
            this.recordedStamps.remove(f);
        }
        this.previousFiles.clear();
        for (IFile f : files) {
            this.previousFiles.add(f);
            long latestRev = this.getModificationTimestamp(f);
            Long lastRev = this.recordedStamps.get(f);
            if (lastRev != null && lastRev >= latestRev) continue;
            this.recordedStamps.put(f, latestRev);
            this.addIFile(delta, commits, f, lastRev == null ? VcsChangeType.ADDED : VcsChangeType.UPDATED);
        }
        if (this.pendingChanges) {
            ++this.revision;
            this.pendingChanges = false;
        }
        delta.setManager((IVcsManager)this);
        if (LOGGER.isInfoEnabled()) {
            long endMillis = System.currentTimeMillis();
            LOGGER.info("getDelta() over workspace - {} ms", (Object)(endMillis - startMillis));
        }
        return delta;
    }

    protected long getModificationTimestamp(IFile f) throws CoreException {
        return f.getModificationStamp();
    }

    private Set<IFile> getAllFiles() {
        try {
            final HashSet<IFile> allFiles = new HashSet<IFile>();
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        allFiles.add((IFile)resource);
                    }
                    return true;
                }
            });
            return allFiles;
        }
        catch (CoreException e) {
            this.console.printerrln((Throwable)e);
            return Collections.emptySet();
        }
    }

    private void addIFile(VcsRepositoryDelta delta, Collection<VcsCommit> commits, IFile f, VcsChangeType changeType) {
        VcsCommit commit = new VcsCommit();
        commit.setAuthor("i am a workspace driver - no authors recorded");
        commit.setJavaDate(new Date());
        commit.setMessage("i am a workspace driver - no messages recorded");
        commit.setRevision(String.valueOf(f.getModificationStamp()));
        commits.add(commit);
        VcsCommitItem c = new VcsCommitItem();
        c.setChangeType(changeType);
        c.setCommit(commit);
        try {
            String encodedPath = URLEncoder.encode(f.getFullPath().toString(), StandardCharsets.UTF_8.toString()).replaceAll("%2F", "/").replaceAll("[+]", "%20");
            c.setPath(encodedPath);
            commit.getItems().add(c);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public File importFile(String revision, String uriEncodedPath, File temp) {
        String decodedPath;
        try {
            decodedPath = URLDecoder.decode(uriEncodedPath, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            decodedPath = uriEncodedPath;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(decodedPath));
        return file.getRawLocation().toFile();
    }

    public boolean isActive() {
        return this.listener != null;
    }

    public void init(String vcsloc, IModelIndexer indexer) throws Exception {
        this.console = indexer.getConsole();
        this.listener = new WorkspaceListener();
    }

    public void run() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener);
    }

    public void shutdown() {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
            this.listener = null;
        }
    }

    public String getLocation() {
        return REPOSITORY_URL;
    }

    public void setCredentials(String username, String password, ICredentialsStore credStore) {
    }

    public String getHumanReadableName() {
        return "Workspace Driver - Workspace Timestamp Based";
    }

    public String getCurrentRevision() throws Exception {
        if (this.pendingChanges) {
            return String.valueOf(this.revision + 1L);
        }
        return String.valueOf(this.revision);
    }

    public Collection<VcsCommitItem> getDelta(String string) throws Exception {
        return this.getDelta(string, this.getCurrentRevision()).getCompactedCommitItems();
    }

    public boolean isAuthSupported() {
        return false;
    }

    public boolean isPathLocationAccepted() {
        return false;
    }

    public boolean isURLLocationAccepted() {
        return true;
    }

    public String getRepositoryPath(String rawPath) {
        if (rawPath.startsWith(REPOSITORY_URL)) {
            return rawPath.substring(REPOSITORY_URL.length());
        }
        if (rawPath.startsWith("pathmap://")) {
            return rawPath;
        }
        try {
            URI uri = new URI(rawPath);
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            if (files.length > 0) {
                String filePath = files[0].getFullPath().toString();
                if (uri.getFragment() == null) {
                    return filePath;
                }
                return String.valueOf(filePath) + "#" + uri.getFragment();
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error("Could not find file " + rawPath + " in the workspace");
        }
        return rawPath;
    }

    public String getUsername() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean f) {
        this.isFrozen = f;
    }

    private final class WorkspaceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean anyChanges = false;

        private WorkspaceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean isFile = delta.getResource() instanceof IFile;
            if (isFile) {
                this.anyChanges = true;
                return true;
            }
            return !isFile;
        }
    }

    private class WorkspaceListener
    implements IResourceChangeListener {
        private WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    Workspace.this.pendingChanges = true;
                    break;
                }
                case 1: {
                    try {
                        IResourceDelta delta = event.getDelta();
                        WorkspaceDeltaVisitor visitor = new WorkspaceDeltaVisitor();
                        delta.accept((IResourceDeltaVisitor)visitor);
                        if (Workspace.this.pendingChanges || !visitor.anyChanges) break;
                        Workspace.this.pendingChanges = true;
                        break;
                    }
                    catch (Exception e) {
                        Workspace.this.console.printerrln((Throwable)e);
                    }
                }
            }
        }
    }
}

