/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.indexes;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexCursor;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class FragmentFilteredIndexCursor
implements Iterator<OIdentifiable> {
    private final String[] fragments;
    private final OIndexCursor cursor;
    OIdentifiable next = null;

    FragmentFilteredIndexCursor(String[] fragments, OIndexCursor cursor) {
        this.fragments = fragments;
        this.cursor = cursor;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        Map.Entry entry = this.cursor.nextEntry();
        block0: while (entry != null) {
            String s = entry.getKey().toString();
            int currentPosition = 0;
            String[] stringArray = this.fragments;
            int n = this.fragments.length;
            int n2 = 0;
            while (n2 < n) {
                String fragment = stringArray[n2];
                int matchPos = s.indexOf(fragment, currentPosition);
                if (matchPos < 0) {
                    entry = this.cursor.nextEntry();
                    continue block0;
                }
                currentPosition = matchPos + fragment.length();
                ++n2;
            }
            this.next = (OIdentifiable)entry.getValue();
            return true;
        }
        return false;
    }

    @Override
    public OIdentifiable next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        OIdentifiable ret = this.next;
        this.next = null;
        return ret;
    }

    @Override
    public void remove() {
        this.cursor.remove();
    }
}

