/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime.augmentation;

import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.augmentation.AugmentationMethod;
import org.eclipse.golo.runtime.augmentation.DefiningModule;

public final class AugmentationApplication {
    private final Class<?> augmentation;
    private final Class<?> target;
    private final DefiningModule.Scope scope;
    private final Kind kind;

    AugmentationApplication(Class<?> augmentation, Class<?> target, DefiningModule.Scope scope, Kind kind) {
        this.scope = scope;
        this.target = target;
        this.augmentation = augmentation;
        this.kind = kind;
    }

    public String toString() {
        return String.format("AugmentationApplication<%s,%s,%s,%s>", new Object[]{this.augmentation, this.target, this.scope, this.kind});
    }

    public Stream<AugmentationMethod> methodsMaching(MethodInvocation invocation) {
        if (this.augmentation == null) {
            return Stream.empty();
        }
        return Stream.of(this.augmentation.getMethods()).filter(invocation::match).map(method -> new AugmentationMethod(this.kind, this.scope, this.target, (Method)method));
    }

    static enum Kind {
        SIMPLE,
        NAMED;

    }
}

