/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.parser;

import org.eclipse.golo.compiler.PositionInSourceCode;
import org.eclipse.golo.compiler.parser.GoloParser;
import org.eclipse.golo.compiler.parser.GoloParserVisitor;
import org.eclipse.golo.compiler.parser.SimpleNode;
import org.eclipse.golo.compiler.parser.Token;

public class GoloASTNode
extends SimpleNode {
    private String documentation;

    public GoloASTNode(int i) {
        super(i);
    }

    public GoloASTNode(GoloParser p, int i) {
        super(p, i);
    }

    public int getLineInSourceCode() {
        return this.jjtGetFirstToken().beginLine;
    }

    public int getColumnInSourceCode() {
        return this.jjtGetFirstToken().beginColumn;
    }

    public PositionInSourceCode getPositionInSourceCode() {
        Token firstToken = this.jjtGetFirstToken();
        if (firstToken == null) {
            return PositionInSourceCode.undefined();
        }
        int startLine = firstToken.beginLine;
        int startColumn = firstToken.beginColumn;
        int endLine = firstToken.endLine;
        int endColumn = firstToken.endColumn;
        Token lastToken = this.jjtGetLastToken();
        if (lastToken != null) {
            endLine = lastToken.endLine;
            endColumn = lastToken.endColumn;
        }
        return PositionInSourceCode.of(startLine, startColumn, endLine, endColumn);
    }

    @Override
    public Object jjtAccept(GoloParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}

