/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ReturnStatement
extends GoloStatement<ReturnStatement> {
    private GoloStatement<?> expressionStatement;
    private boolean returningVoid;
    private boolean synthetic;

    private ReturnStatement(ExpressionStatement<?> expression) {
        this.setExpressionStatement(expression);
        this.returningVoid = false;
        this.synthetic = false;
    }

    public static ReturnStatement of(Object value) {
        return new ReturnStatement(ExpressionStatement.of(value));
    }

    public static ReturnStatement empty() {
        return new ReturnStatement(null).returningVoid();
    }

    @Override
    protected ReturnStatement self() {
        return this;
    }

    public GoloStatement<?> expression() {
        return this.expressionStatement;
    }

    private void setExpressionStatement(GoloStatement<?> stat) {
        this.expressionStatement = stat != null ? this.makeParentOf(stat) : null;
    }

    public boolean isReturningVoid() {
        return this.returningVoid;
    }

    public ReturnStatement returningVoid() {
        this.returningVoid = true;
        return this;
    }

    public ReturnStatement synthetic() {
        this.synthetic = true;
        return this;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public String toString() {
        return "return " + (this.returningVoid || this.expressionStatement == null ? "" : this.expressionStatement.toString());
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitReturnStatement(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        if (this.expressionStatement != null) {
            return Collections.singletonList(this.expressionStatement);
        }
        return Collections.emptyList();
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!Objects.equals(original, this.expressionStatement) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.setExpressionStatement(ExpressionStatement.of(newElement));
    }
}

