/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.AssignmentStatement;
import gololang.ir.Augmentation;
import gololang.ir.Block;
import gololang.ir.FunctionContainer;
import gololang.ir.GoloElement;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloType;
import gololang.ir.LocalReference;
import gololang.ir.ModuleImport;
import gololang.ir.NamedAugmentation;
import gololang.ir.Noop;
import gololang.ir.ReferenceTable;
import gololang.ir.ToplevelElements;
import gololang.ir.Union;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.golo.compiler.PackageAndClass;

public final class GoloModule
extends GoloElement<GoloModule>
implements FunctionContainer {
    private String sourceFile;
    private final PackageAndClass packageAndClass;
    private final ReferenceTable globalReferences;
    private final List<ModuleImport> imports = new LinkedList<ModuleImport>();
    private final Set<GoloFunction> functions = new LinkedHashSet<GoloFunction>();
    private final Map<PackageAndClass, Augmentation> augmentations = new LinkedHashMap<PackageAndClass, Augmentation>();
    private final Set<NamedAugmentation> namedAugmentations = new LinkedHashSet<NamedAugmentation>();
    private final Set<GoloType<?>> types = new LinkedHashSet();
    private final Set<LocalReference> moduleState = new LinkedHashSet<LocalReference>();
    private GoloFunction moduleStateInitializer = null;
    private boolean hasMain = false;
    private static final ModuleImport[] DEFAULT_IMPORTS = new ModuleImport[]{ModuleImport.implicit("gololang.Predefined"), ModuleImport.implicit("gololang.StandardAugmentations"), ModuleImport.implicit("gololang"), ModuleImport.implicit("java.lang")};
    public static final String MODULE_INITIALIZER_FUNCTION = "<clinit>";
    public static final String TYPE_SUBPACKAGE = "types";

    private GoloModule(PackageAndClass name, ReferenceTable references) {
        this.packageAndClass = name;
        this.globalReferences = references;
    }

    public static GoloModule create(PackageAndClass name, ReferenceTable references) {
        return new GoloModule(name, references == null ? new ReferenceTable() : references);
    }

    @Override
    protected GoloModule self() {
        return this;
    }

    @Override
    public PackageAndClass getPackageAndClass() {
        return this.packageAndClass;
    }

    public PackageAndClass getTypesPackage() {
        return this.packageAndClass.createSubPackage(TYPE_SUBPACKAGE);
    }

    public String sourceFile() {
        return this.sourceFile == null ? "unknown" : this.sourceFile;
    }

    public GoloModule sourceFile(String file) {
        this.sourceFile = file;
        return this;
    }

    public ReferenceTable getReferenceTable() {
        return this.globalReferences;
    }

    @Override
    public GoloModule enclosingModule() {
        return this;
    }

    public Set<ModuleImport> getImports() {
        LinkedHashSet<ModuleImport> imp = new LinkedHashSet<ModuleImport>();
        if (!this.types.isEmpty()) {
            imp.add(ModuleImport.implicit(this.getTypesPackage()));
            for (GoloType<?> t : this.types) {
                if (!(t instanceof Union)) continue;
                imp.add(ModuleImport.implicit(t.getPackageAndClass()));
            }
        }
        imp.addAll(this.imports);
        if (this.packageAndClass.hasPackage()) {
            imp.add(ModuleImport.implicit(this.packageAndClass.parentPackage()));
        }
        Collections.addAll(imp, DEFAULT_IMPORTS);
        return imp;
    }

    public Collection<Augmentation> getAugmentations() {
        return Collections.unmodifiableCollection(this.augmentations.values());
    }

    @Override
    public List<GoloFunction> getFunctions() {
        return new ArrayList<GoloFunction>(this.functions);
    }

    @Override
    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    public boolean hasMain() {
        return this.hasMain;
    }

    @Override
    public void addFunction(GoloFunction function) {
        function.getBlock().getReferenceTable().relinkTopLevel(this.globalReferences);
        this.functions.add(this.makeParentOf(function));
        if (function.isMain()) {
            this.hasMain = true;
        }
    }

    private void addAugmentation(Augmentation augment) {
        PackageAndClass target = augment.getTarget();
        if (this.augmentations.containsKey(target)) {
            this.augmentations.get(target).merge(augment);
        } else {
            this.augmentations.put(target, augment);
        }
    }

    public GoloElement<?> getSubtypeByName(String name) {
        if (name == null) {
            return null;
        }
        for (GoloType<?> t : this.types) {
            if (!name.equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    private void addModuleStateInitializer(AssignmentStatement assignment) {
        if (!assignment.isDeclaring()) {
            throw new IllegalArgumentException("Module state must be a declaring assignment");
        }
        assignment.getLocalReference().moduleLevel();
        this.moduleState.add(assignment.getLocalReference());
        if (this.moduleStateInitializer == null) {
            this.moduleStateInitializer = GoloFunction.function(MODULE_INITIALIZER_FUNCTION).block(Block.empty().ref(this.globalReferences));
            this.functions.add(this.moduleStateInitializer);
        }
        this.moduleStateInitializer.getBlock().add(assignment);
    }

    public GoloModule add(GoloElement<?> element) {
        if (element == null || element instanceof Noop) {
            return this;
        }
        if (element instanceof ToplevelElements) {
            for (GoloElement<?> e : (ToplevelElements)element) {
                this.add(e);
            }
            return this;
        }
        this.makeParentOf(element);
        if (element instanceof ModuleImport) {
            this.imports.add((ModuleImport)element);
        } else if (element instanceof GoloFunction) {
            this.addFunction((GoloFunction)element);
        } else if (element instanceof GoloType) {
            GoloType t = (GoloType)element;
            this.types.add(t);
        } else if (element instanceof Augmentation) {
            this.addAugmentation((Augmentation)element);
        } else if (element instanceof NamedAugmentation) {
            this.namedAugmentations.add((NamedAugmentation)element);
        } else if (element instanceof LocalReference) {
            this.moduleState.add((LocalReference)element);
        } else if (element instanceof AssignmentStatement) {
            this.addModuleStateInitializer((AssignmentStatement)element);
        } else {
            throw new IllegalArgumentException("Can't add a " + element.getClass() + " to a module");
        }
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitModule(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList();
        children.addAll(this.getImports());
        children.addAll(this.types);
        children.addAll(this.augmentations.values());
        children.addAll(this.namedAugmentations);
        children.addAll(this.moduleState);
        children.addAll(this.functions);
        return children;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty() && this.types.isEmpty() && this.augmentations.isEmpty() && this.namedAugmentations.isEmpty() && this.moduleState.isEmpty() && this.functions.isEmpty();
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (!(original instanceof GoloFunction)) {
            throw this.cantReplace(original, newElement);
        }
        this.functions.remove(original);
        this.add(newElement);
    }

    public String toString() {
        return String.format("GoloModule{name=%s, src=%s}", this.packageAndClass, this.sourceFile);
    }
}

