/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.Block;
import gololang.ir.ConstantStatement;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import gololang.ir.Noop;
import java.util.LinkedList;
import java.util.List;

public final class ConditionalBranching
extends GoloStatement<ConditionalBranching> {
    private ExpressionStatement<?> condition;
    private Block trueBlock;
    private ConditionalBranching elseConditionalBranching;
    private Block falseBlock;

    private ConditionalBranching() {
    }

    public static ConditionalBranching branch() {
        return new ConditionalBranching();
    }

    public static ConditionalBranching create(Object condition, Object trueBlock, Object falseBlock, Object elseBranch) {
        return new ConditionalBranching().condition(condition).whenTrue(trueBlock).whenFalse(falseBlock).elseBranch(elseBranch);
    }

    @Override
    protected ConditionalBranching self() {
        return this;
    }

    public ConditionalBranching condition(Object cond) {
        this.condition = cond == null ? ConstantStatement.of(false) : ExpressionStatement.of(cond);
        this.makeParentOf(this.condition);
        return this;
    }

    public ConditionalBranching whenTrue(Object block) {
        this.trueBlock = this.makeParentOf(Block.of(block));
        return this;
    }

    public ConditionalBranching whenFalse(Object block) {
        this.falseBlock = block == null ? null : this.makeParentOf(Block.of(block));
        return this;
    }

    public ConditionalBranching elseBranch(Object elseBranch) {
        this.elseConditionalBranching = this.makeParentOf((ConditionalBranching)elseBranch);
        return this;
    }

    public ConditionalBranching otherwise(Object alternative) {
        if (alternative instanceof ConditionalBranching) {
            return this.elseBranch(alternative);
        }
        return this.whenFalse(alternative);
    }

    public ExpressionStatement<?> getCondition() {
        return this.condition;
    }

    public Block getTrueBlock() {
        return this.trueBlock;
    }

    public Block getFalseBlock() {
        return this.falseBlock;
    }

    public boolean hasFalseBlock() {
        return this.falseBlock != null;
    }

    public ConditionalBranching getElseConditionalBranching() {
        return this.elseConditionalBranching;
    }

    public boolean hasElseConditionalBranching() {
        return this.elseConditionalBranching != null;
    }

    public boolean returnsFromBothBranches() {
        if (this.hasFalseBlock()) {
            return this.trueBlock.hasReturn() && this.falseBlock.hasReturn();
        }
        if (this.hasElseConditionalBranching()) {
            return this.trueBlock.hasReturn() && this.elseConditionalBranching.returnsFromBothBranches();
        }
        return false;
    }

    public String toString() {
        return String.format("if %s %s%s", this.condition, this.trueBlock, this.hasFalseBlock() ? " else " + this.falseBlock.toString() : (this.hasElseConditionalBranching() ? " else " + this.elseConditionalBranching.toString() : ""));
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitConditionalBranching(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList();
        children.add(this.condition);
        children.add(this.trueBlock);
        if (this.falseBlock != null) {
            children.add(this.falseBlock);
        }
        if (this.elseConditionalBranching != null) {
            children.add(this.elseConditionalBranching);
        }
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (this.condition == original) {
            this.condition(newElement);
        } else if (this.trueBlock == original) {
            this.whenTrue(newElement);
        } else if (this.elseConditionalBranching == original && newElement instanceof ConditionalBranching) {
            this.elseBranch(newElement);
        } else if (this.elseConditionalBranching == original) {
            this.whenFalse(newElement instanceof Noop ? null : newElement);
            this.elseBranch(null);
        } else if (this.falseBlock == original && newElement instanceof ConditionalBranching) {
            this.elseBranch(newElement);
            this.whenFalse(null);
        } else if (this.falseBlock == original) {
            this.whenFalse(newElement instanceof Noop ? null : newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

