/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.Predefined;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;

public class FunctionReference {
    private final MethodHandle handle;
    private final String[] parameterNames;

    public FunctionReference(MethodHandle handle, String[] parameterNames) {
        if (handle == null) {
            throw new IllegalArgumentException("A method handle cannot be null");
        }
        this.handle = handle;
        this.parameterNames = parameterNames;
    }

    public FunctionReference(MethodHandle handle) {
        this(handle, null);
    }

    public MethodHandle handle() {
        return this.handle;
    }

    public String[] parameterNames() {
        return Arrays.copyOf(this.parameterNames, this.parameterNames.length);
    }

    public MethodType type() {
        return this.handle.type();
    }

    public FunctionReference asCollector(Class<?> arrayType, int arrayLength) {
        return new FunctionReference(this.handle.asCollector(arrayType, arrayLength), this.parameterNames);
    }

    public FunctionReference asCollector(int arrayLength) {
        return this.asCollector(Object[].class, arrayLength);
    }

    public FunctionReference asFixedArity() {
        return new FunctionReference(this.handle.asFixedArity(), this.parameterNames);
    }

    public FunctionReference asType(MethodType newType) {
        return new FunctionReference(this.handle.asType(newType), this.parameterNames);
    }

    public FunctionReference asVarargsCollector(Class<?> arrayType) {
        if (this.isVarargsCollector()) {
            return this;
        }
        return new FunctionReference(this.handle.asVarargsCollector(arrayType), this.parameterNames);
    }

    public FunctionReference asVarargsCollector() {
        return this.asVarargsCollector(Object[].class);
    }

    public FunctionReference bindTo(Object x) {
        MethodHandle mh = this.handle.bindTo(x);
        if (this.isVarargsCollector() && this.arity() > 1) {
            mh = mh.asVarargsCollector(Object[].class);
        }
        return new FunctionReference(mh, this.dropParameterNames(0, 1));
    }

    public boolean isVarargsCollector() {
        return this.handle.isVarargsCollector();
    }

    public FunctionReference asSpreader(Class<?> arrayType, int arrayLength) {
        return new FunctionReference(this.handle.asSpreader(arrayType, arrayLength));
    }

    public FunctionReference asSpreader(int arrayLength) {
        return this.asSpreader(Object[].class, arrayLength);
    }

    public FunctionReference asSpreader() {
        return this.asSpreader(Object[].class, this.arity());
    }

    public int arity() {
        return this.handle.type().parameterCount();
    }

    public boolean acceptArity(int nb) {
        return this.arity() == nb || nb >= this.arity() - 1 && this.isVarargsCollector();
    }

    public Object invoke(Object ... args) throws Throwable {
        return this.handle.invokeWithArguments(args);
    }

    public Object invokeOrBind(Object ... args) throws Throwable {
        if (args.length < this.arity()) {
            return this.insertArguments(0, args);
        }
        return this.handle.invokeWithArguments(args);
    }

    public String toString() {
        return String.format("FunctionReference{handle=%s%s, parameterNames=%s}", this.handle.isVarargsCollector() ? "(varargs)" : "", this.handle, Arrays.toString(this.parameterNames));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionReference that = (FunctionReference)obj;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public Object to(Class<?> interfaceClass) {
        return Predefined.asInterfaceInstance(interfaceClass, this);
    }

    public FunctionReference andThen(FunctionReference fun) {
        MethodHandle other = null;
        if (fun.isVarargsCollector() && fun.arity() == 1) {
            other = fun.handle.asCollector(Object[].class, 1);
        } else if (fun.isVarargsCollector() && fun.arity() == 2) {
            other = MethodHandles.insertArguments(fun.handle, 1, new Object[]{new Object[0]});
        } else if (fun.arity() == 0) {
            other = MethodHandles.dropArguments(fun.handle, 0, new Class[]{Object.class});
        } else if (fun.arity() == 1) {
            other = fun.handle;
        } else {
            throw new IllegalArgumentException("`andThen` requires a function that can be applied to 0 or 1 parameter");
        }
        MethodHandle mh = MethodHandles.filterReturnValue(this.handle.asType(this.handle.type().changeReturnType(Object.class)), other.asType(other.type().changeParameterType(0, Object.class)));
        if (this.isVarargsCollector()) {
            mh = mh.asVarargsCollector(Object[].class);
        }
        return new FunctionReference(mh, this.parameterNames);
    }

    public FunctionReference compose(FunctionReference fun) {
        if (!this.acceptArity(1) && !this.acceptArity(0)) {
            throw new UnsupportedOperationException("`compose` must be called on function accepting 0 or 1 parameter");
        }
        return fun.andThen(this);
    }

    public FunctionReference bindAt(int position, Object value) {
        MethodHandle mh = MethodHandles.insertArguments(this.handle, position, value);
        if (this.isVarargsCollector() && position < this.arity() - 1) {
            mh = mh.asVarargsCollector(Object[].class);
        }
        return new FunctionReference(mh, this.dropParameterNames(position, 1));
    }

    public FunctionReference bindAt(String parameterName, Object value) {
        int position = -1;
        if (this.parameterNames == null) {
            throw new RuntimeException("Can't bind on parameter name, " + this.toString() + " has none");
        }
        for (int i = 0; i < this.parameterNames.length; ++i) {
            if (!this.parameterNames[i].equals(parameterName)) continue;
            position = i;
            break;
        }
        if (position == -1) {
            throw new IllegalArgumentException("'" + parameterName + "' not in the parameter list " + Arrays.toString(this.parameterNames));
        }
        return this.bindAt(position, value);
    }

    public FunctionReference insertArguments(int position, Object ... values) {
        if (values.length == 0) {
            return this;
        }
        MethodHandle mh = MethodHandles.insertArguments(this.handle, position, values);
        if (this.isVarargsCollector() && position < this.arity() - 1) {
            mh = mh.asVarargsCollector(Object[].class);
        }
        return new FunctionReference(mh, this.dropParameterNames(position, values.length));
    }

    public Object spread(Object ... arguments) throws Throwable {
        int arity = this.arity();
        if (this.handle.isVarargsCollector() && arity > 0 && arguments[arity - 1] instanceof Object[]) {
            return this.handle.asFixedArity().asSpreader(Object[].class, arguments.length).invoke(arguments);
        }
        return this.handle.asSpreader(Object[].class, arguments.length).invoke(arguments);
    }

    private String[] dropParameterNames(int from, int size) {
        if (this.parameterNames == null) {
            return null;
        }
        String[] filtered = new String[this.parameterNames.length - size];
        if (filtered.length > 0) {
            System.arraycopy(this.parameterNames, 0, filtered, 0, from);
            System.arraycopy(this.parameterNames, from + size, filtered, from, this.parameterNames.length - size - from);
        }
        return filtered;
    }
}

