/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameterized;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WrappedParameter {
    private Parameter m_parameter;
    private DynamicParameter m_dynamicParameter;

    public WrappedParameter(Parameter parameter) {
        this.m_parameter = parameter;
    }

    public WrappedParameter(DynamicParameter dynamicParameter) {
        this.m_dynamicParameter = dynamicParameter;
    }

    public Parameter getParameter() {
        return this.m_parameter;
    }

    public DynamicParameter getDynamicParameter() {
        return this.m_dynamicParameter;
    }

    public int arity() {
        return this.m_parameter != null ? this.m_parameter.arity() : 1;
    }

    public boolean hidden() {
        return this.m_parameter != null ? this.m_parameter.hidden() : this.m_dynamicParameter.hidden();
    }

    public boolean required() {
        return this.m_parameter != null ? this.m_parameter.required() : this.m_dynamicParameter.required();
    }

    public boolean password() {
        return this.m_parameter != null ? this.m_parameter.password() : false;
    }

    public String[] names() {
        return this.m_parameter != null ? this.m_parameter.names() : this.m_dynamicParameter.names();
    }

    public boolean variableArity() {
        return this.m_parameter != null ? this.m_parameter.variableArity() : false;
    }

    public Class<? extends IParameterValidator> validateWith() {
        return this.m_parameter != null ? this.m_parameter.validateWith() : this.m_dynamicParameter.validateWith();
    }

    public Class<? extends IValueValidator> validateValueWith() {
        return this.m_parameter != null ? this.m_parameter.validateValueWith() : this.m_dynamicParameter.validateValueWith();
    }

    public boolean echoInput() {
        return this.m_parameter != null ? this.m_parameter.echoInput() : false;
    }

    public void addValue(Parameterized parameterized, Object object, Object object2) {
        if (this.m_parameter != null) {
            parameterized.set(object, object2);
        } else {
            String string = this.m_dynamicParameter.assignment();
            String string2 = object2.toString();
            int n = string2.indexOf(string);
            if (n == -1) {
                throw new ParameterException("Dynamic parameter expected a value of the form a" + string + "b but got:" + string2);
            }
            this.callPut(object, parameterized, string2.substring(0, n), string2.substring(n + 1));
        }
    }

    private void callPut(Object object, Parameterized parameterized, String string, String string2) {
        try {
            Method method = this.findPut(parameterized.getType());
            method.invoke(parameterized.get(object), string, string2);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    private Method findPut(Class<?> clazz) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod("put", Object.class, Object.class);
    }

    public String getAssignment() {
        return this.m_dynamicParameter != null ? this.m_dynamicParameter.assignment() : "";
    }

    public boolean isHelp() {
        return this.m_parameter != null && this.m_parameter.help();
    }

    public boolean isNonOverwritableForced() {
        return this.m_parameter != null && this.m_parameter.forceNonOverwritable();
    }
}

