/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Objects;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class ThrowStatement
extends GoloStatement {
    private GoloStatement expressionStatement;

    ThrowStatement(GoloStatement expressionStatement) {
        this.setExpressionStatement(expressionStatement);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitThrowStatement(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.expressionStatement.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!Objects.equals(original, this.expressionStatement) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.setExpressionStatement((ExpressionStatement)newElement);
    }

    public GoloStatement getExpressionStatement() {
        return this.expressionStatement;
    }

    private void setExpressionStatement(GoloStatement stat) {
        this.expressionStatement = stat;
        this.makeParentOf(stat);
    }

    @Override
    public ThrowStatement ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }
}

