/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.golo.compiler.ir.Builders;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferencesHolder;

public final class ReferenceTable {
    private ReferenceTable parent;
    private final Map<String, LocalReference> table = new LinkedHashMap<String, LocalReference>();

    public ReferenceTable() {
        this(null);
    }

    private ReferenceTable(ReferenceTable parent) {
        this.parent = parent;
    }

    public ReferenceTable add(LocalReference reference) {
        this.table.put(reference.getName(), reference);
        return this;
    }

    public int size() {
        return this.table.size() + (this.parent != null ? this.parent.size() : 0);
    }

    public boolean hasReferenceFor(String name) {
        return this.table.containsKey(name) || this.parent != null && this.parent.hasReferenceFor(name);
    }

    public void updateFrom(GoloStatement statement) {
        if (statement instanceof ReferencesHolder) {
            for (LocalReference r : ((ReferencesHolder)((Object)statement)).getDeclaringReferences()) {
                this.add(r);
            }
        }
    }

    public LocalReference get(String name) {
        LocalReference reference = this.table.get(name);
        if (reference != null) {
            return reference;
        }
        if (this.parent != null && this.parent != this) {
            return this.parent.get(name);
        }
        return null;
    }

    public Set<String> ownedSymbols() {
        return Collections.unmodifiableSet(this.table.keySet());
    }

    public Collection<LocalReference> ownedReferences() {
        return Collections.unmodifiableCollection(this.table.values());
    }

    public void relink(ReferenceTable parent, boolean prune) {
        if (parent == this) {
            return;
        }
        if (prune) {
            for (LocalReference reference : parent.references()) {
                if (!this.hasReferenceFor(reference.getName())) continue;
                this.remove(reference.getName());
            }
        }
        this.parent = parent;
    }

    public void relink(ReferenceTable parent) {
        this.relink(parent, true);
    }

    private boolean isLinkedTo(ReferenceTable other) {
        if (this != other && this.parent == null) {
            return false;
        }
        return this == other || this.parent == other || this.parent.isLinkedTo(other);
    }

    public void relinkTopLevel(ReferenceTable topLevel) {
        if (this == topLevel) {
            return;
        }
        if (this.parent == null) {
            this.parent = topLevel;
        } else if (!this.isLinkedTo(topLevel) && !topLevel.isLinkedTo(this)) {
            this.parent.relinkTopLevel(topLevel);
        }
    }

    public Set<String> symbols() {
        LinkedHashSet<String> localSymbols = new LinkedHashSet<String>(this.table.keySet());
        if (this.parent != null) {
            localSymbols.addAll(this.parent.symbols());
        }
        return localSymbols;
    }

    public Collection<LocalReference> references() {
        LinkedHashSet<LocalReference> localReferences = new LinkedHashSet<LocalReference>(this.table.values());
        if (this.parent != null) {
            for (LocalReference ref : this.parent.references()) {
                if (this.table.containsKey(ref.getName())) continue;
                localReferences.add(ref);
            }
        }
        return localReferences;
    }

    public ReferenceTable fork() {
        return new ReferenceTable(this);
    }

    public ReferenceTable flatDeepCopy(boolean turnIntoConstants) {
        ReferenceTable referenceTable = new ReferenceTable();
        Set<String> tableSymbols = this.ownedSymbols();
        for (LocalReference reference : this.references()) {
            String refName = reference.getName();
            if (reference.isModuleState()) {
                referenceTable.add(Builders.localRef(refName).kind(reference.getKind()));
                continue;
            }
            if (turnIntoConstants && !tableSymbols.contains(refName)) {
                referenceTable.add(Builders.localRef(refName).synthetic(reference.isSynthetic()));
                continue;
            }
            referenceTable.add(Builders.localRef(refName).kind(reference.getKind()).synthetic(reference.isSynthetic()));
        }
        return referenceTable;
    }

    public void remove(String name) {
        this.table.remove(name);
    }

    public String toString() {
        StringBuilder representation = new StringBuilder("ReferenceTable: {\n");
        for (Map.Entry<String, LocalReference> elt : this.table.entrySet()) {
            representation.append(elt.getKey()).append(": ").append(elt.getValue()).append('\n');
        }
        representation.append('}');
        if (this.parent != null && this.parent != this) {
            representation.append(" => ").append(this.parent.toString());
        }
        return representation.toString();
    }
}

