/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.Augmentation;
import org.eclipse.golo.compiler.ir.BinaryOperation;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.CaseStatement;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.CollectionComprehension;
import org.eclipse.golo.compiler.ir.CollectionLiteral;
import org.eclipse.golo.compiler.ir.ConditionalBranching;
import org.eclipse.golo.compiler.ir.ConstantStatement;
import org.eclipse.golo.compiler.ir.Decorator;
import org.eclipse.golo.compiler.ir.DestructuringAssignment;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.ForEachLoopStatement;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloAssignment;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloModule;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.LoopBreakFlowStatement;
import org.eclipse.golo.compiler.ir.LoopStatement;
import org.eclipse.golo.compiler.ir.MatchExpression;
import org.eclipse.golo.compiler.ir.Member;
import org.eclipse.golo.compiler.ir.MethodInvocation;
import org.eclipse.golo.compiler.ir.ModuleImport;
import org.eclipse.golo.compiler.ir.NamedArgument;
import org.eclipse.golo.compiler.ir.NamedAugmentation;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.ir.ReturnStatement;
import org.eclipse.golo.compiler.ir.Struct;
import org.eclipse.golo.compiler.ir.ThrowStatement;
import org.eclipse.golo.compiler.ir.TryCatchFinally;
import org.eclipse.golo.compiler.ir.UnaryOperation;
import org.eclipse.golo.compiler.ir.Union;
import org.eclipse.golo.compiler.ir.UnionValue;
import org.eclipse.golo.compiler.ir.WhenClause;

public class IrTreeDumper
implements GoloIrVisitor {
    private int spacing = 0;

    private void space() {
        System.out.print("# ");
        for (int i = 0; i < this.spacing; ++i) {
            System.out.print(" ");
        }
    }

    private void incr() {
        this.spacing += 2;
    }

    private void decr() {
        this.spacing -= 2;
    }

    @Override
    public void visitModule(GoloModule module) {
        this.space();
        System.out.println(module.getPackageAndClass());
        module.walk(this);
    }

    @Override
    public void visitModuleImport(ModuleImport moduleImport) {
        this.incr();
        this.space();
        System.out.println(" - " + moduleImport);
        moduleImport.walk(this);
        this.decr();
    }

    @Override
    public void visitNamedAugmentation(NamedAugmentation namedAugmentation) {
        this.incr();
        this.space();
        System.out.println("Named Augmentation " + namedAugmentation.getName());
        namedAugmentation.walk(this);
        this.decr();
    }

    @Override
    public void visitAugmentation(Augmentation augmentation) {
        this.incr();
        this.space();
        System.out.println("Augmentation on " + augmentation.getTarget());
        if (augmentation.hasNames()) {
            this.incr();
            for (String name : augmentation.getNames()) {
                this.space();
                System.out.println("Named Augmentation " + name);
            }
            this.decr();
        }
        augmentation.walk(this);
        this.decr();
    }

    @Override
    public void visitStruct(Struct struct) {
        this.incr();
        this.space();
        System.out.println("Struct " + struct.getPackageAndClass().className());
        this.space();
        System.out.println(" - target class = " + struct.getPackageAndClass());
        this.incr();
        this.space();
        System.out.println("Members: ");
        struct.walk(this);
        this.decr();
        this.decr();
    }

    @Override
    public void visitUnion(Union union) {
        this.incr();
        this.space();
        System.out.println("Union " + union.getPackageAndClass().className());
        this.space();
        System.out.println(" - target class = " + union.getPackageAndClass());
        union.walk(this);
        this.decr();
    }

    @Override
    public void visitUnionValue(UnionValue value) {
        this.incr();
        this.space();
        System.out.println("Value " + value.getPackageAndClass().className());
        this.space();
        System.out.println(" - target class = " + value.getPackageAndClass());
        if (value.hasMembers()) {
            this.space();
            System.out.println(" - members = " + value.getMembers());
        }
        this.decr();
    }

    @Override
    public void visitFunction(GoloFunction function) {
        this.incr();
        this.space();
        System.out.print("Function " + function.getName() + " = ");
        this.visitFunctionDefinition(function);
        this.decr();
    }

    private void visitFunctionDefinition(GoloFunction function) {
        System.out.print("|");
        boolean first = true;
        for (String param : function.getParameterNames()) {
            if (first) {
                first = false;
            } else {
                System.out.print(", ");
            }
            System.out.print(param);
        }
        System.out.print("|");
        if (function.isVarargs()) {
            System.out.print(" (varargs)");
        }
        if (function.isSynthetic()) {
            System.out.print(" (synthetic, " + function.getSyntheticParameterCount() + " synthetic parameters)");
            if (function.getSyntheticSelfName() != null) {
                System.out.print(" (selfname: " + function.getSyntheticSelfName() + ")");
            }
        }
        System.out.println();
        function.walk(this);
    }

    @Override
    public void visitDecorator(Decorator decorator) {
        this.incr();
        this.space();
        System.out.println("@Decorator");
        decorator.walk(this);
        this.decr();
    }

    @Override
    public void visitBlock(Block block) {
        if (block.isEmpty()) {
            return;
        }
        this.incr();
        this.space();
        System.out.println("Block");
        block.walk(this);
        this.decr();
    }

    @Override
    public void visitLocalReference(LocalReference ref) {
        this.incr();
        this.space();
        System.out.println(" - " + ref);
        this.decr();
    }

    @Override
    public void visitConstantStatement(ConstantStatement constantStatement) {
        this.incr();
        this.space();
        System.out.println("Constant = " + constantStatement.getValue());
        this.decr();
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) {
        this.incr();
        this.space();
        System.out.println("Return");
        returnStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        this.incr();
        this.space();
        System.out.println("Function call: " + functionInvocation.getName() + ", on reference? -> " + functionInvocation.isOnReference() + ", on module state? -> " + functionInvocation.isOnModuleState() + ", anonymous? -> " + functionInvocation.isAnonymous() + ", named arguments? -> " + functionInvocation.usesNamedArguments());
        functionInvocation.walk(this);
        this.printLocalDeclarations(functionInvocation);
        this.decr();
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        this.incr();
        this.space();
        System.out.print("Assignment: " + assignmentStatement.getLocalReference());
        System.out.println(assignmentStatement.isDeclaring() ? " (declaring)" : "");
        assignmentStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitDestructuringAssignment(DestructuringAssignment assignment) {
        this.incr();
        this.space();
        System.out.format("Destructuring assignement: {declaring=%s, varargs=%s}%n", assignment.isDeclaring(), assignment.isVarargs());
        assignment.walk(this);
        this.decr();
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        this.incr();
        this.space();
        System.out.println("Reference lookup: " + referenceLookup.getName());
        this.printLocalDeclarations(referenceLookup);
        this.decr();
    }

    @Override
    public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        this.incr();
        this.space();
        System.out.println("Conditional");
        conditionalBranching.walk(this);
        this.decr();
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) {
        this.incr();
        this.space();
        System.out.println("Case");
        this.incr();
        for (WhenClause<Block> c : caseStatement.getClauses()) {
            c.accept(this);
        }
        this.space();
        System.out.println("Otherwise");
        caseStatement.getOtherwise().accept(this);
        this.decr();
    }

    @Override
    public void visitMatchExpression(MatchExpression matchExpression) {
        this.incr();
        this.space();
        System.out.println("Match");
        this.incr();
        for (WhenClause<ExpressionStatement> c : matchExpression.getClauses()) {
            c.accept(this);
        }
        this.space();
        System.out.println("Otherwise");
        matchExpression.getOtherwise().accept(this);
        this.printLocalDeclarations(matchExpression);
        this.decr();
    }

    @Override
    public void visitWhenClause(WhenClause<?> whenClause) {
        this.space();
        System.out.println("When");
        this.incr();
        whenClause.walk(this);
        this.decr();
    }

    @Override
    public void visitBinaryOperation(BinaryOperation binaryOperation) {
        this.incr();
        this.space();
        System.out.println("Binary operator: " + (Object)((Object)binaryOperation.getType()));
        binaryOperation.walk(this);
        this.printLocalDeclarations(binaryOperation);
        this.decr();
    }

    @Override
    public void visitUnaryOperation(UnaryOperation unaryOperation) {
        this.incr();
        this.space();
        System.out.println("Unary operator: " + (Object)((Object)unaryOperation.getType()));
        unaryOperation.getExpressionStatement().accept(this);
        this.printLocalDeclarations(unaryOperation);
        this.decr();
    }

    @Override
    public void visitLoopStatement(LoopStatement loopStatement) {
        this.incr();
        this.space();
        System.out.println("Loop");
        loopStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitForEachLoopStatement(ForEachLoopStatement foreachStatement) {
        this.incr();
        this.space();
        System.out.println("Foreach");
        this.incr();
        for (LocalReference ref : foreachStatement.getReferences()) {
            ref.accept(this);
        }
        foreachStatement.getIterable().accept(this);
        if (foreachStatement.hasWhenClause()) {
            this.space();
            System.out.println("When:");
            foreachStatement.getWhenClause().accept(this);
        }
        foreachStatement.getBlock().accept(this);
        this.decr();
        this.decr();
    }

    @Override
    public void visitMethodInvocation(MethodInvocation methodInvocation) {
        this.incr();
        this.space();
        System.out.format("Method invocation: %s, null safe? -> %s%n", methodInvocation.getName(), methodInvocation.isNullSafeGuarded());
        methodInvocation.walk(this);
        this.printLocalDeclarations(methodInvocation);
        this.decr();
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        this.incr();
        this.space();
        System.out.println("Throw");
        throwStatement.walk(this);
        this.decr();
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        this.incr();
        this.space();
        System.out.println("Try");
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.hasCatchBlock()) {
            this.space();
            System.out.println("Catch: " + tryCatchFinally.getExceptionId());
            tryCatchFinally.getCatchBlock().accept(this);
        }
        if (tryCatchFinally.hasFinallyBlock()) {
            this.space();
            System.out.println("Finally");
            tryCatchFinally.getFinallyBlock().accept(this);
        }
        this.decr();
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        GoloFunction target = closureReference.getTarget();
        this.incr();
        this.space();
        if (target.isAnonymous()) {
            System.out.print("Closure: ");
            this.incr();
            this.visitFunctionDefinition(target);
            this.decr();
        } else {
            System.out.printf("Closure reference: %s, regular arguments at index %d%n", target.getName(), target.getSyntheticParameterCount());
            this.incr();
            for (String refName : closureReference.getCapturedReferenceNames()) {
                this.space();
                System.out.println("- capture: " + refName);
            }
            this.decr();
        }
        this.decr();
    }

    @Override
    public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        this.incr();
        this.space();
        System.out.println("Loop break flow: " + loopBreakFlowStatement.getType().name());
        this.decr();
    }

    @Override
    public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        this.incr();
        this.space();
        System.out.println("Collection literal of type: " + (Object)((Object)collectionLiteral.getType()));
        collectionLiteral.walk(this);
        this.printLocalDeclarations(collectionLiteral);
        this.decr();
    }

    @Override
    public void visitCollectionComprehension(CollectionComprehension collectionComprehension) {
        this.incr();
        this.space();
        System.out.println("Collection comprehension of type: " + (Object)((Object)collectionComprehension.getType()));
        this.incr();
        this.space();
        System.out.println("Expression: ");
        collectionComprehension.getExpression().accept(this);
        this.space();
        System.out.println("Comprehension: ");
        for (Block b : collectionComprehension.getLoopBlocks()) {
            b.accept(this);
        }
        this.printLocalDeclarations(collectionComprehension);
        this.decr();
        this.decr();
    }

    @Override
    public void visitNamedArgument(NamedArgument namedArgument) {
        this.incr();
        this.space();
        System.out.println("Named argument: " + namedArgument.getName());
        namedArgument.getExpression().accept(this);
        this.decr();
    }

    @Override
    public void visitMember(Member member) {
        this.space();
        System.out.print(" - ");
        System.out.print(member.getName());
        System.out.println();
    }

    private void printLocalDeclarations(ExpressionStatement expr) {
        if (expr.hasLocalDeclarations()) {
            this.incr();
            this.space();
            System.out.println("Local declaration:");
            for (GoloAssignment a : expr.declarations()) {
                a.accept(this);
            }
            this.decr();
        }
    }
}

