/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.golo.compiler.ir.AbstractGoloIrVisitor;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.PositionInSourceCode;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public abstract class GoloElement {
    private WeakReference<GoloASTNode> nodeRef;
    private Optional<GoloElement> parent = Optional.empty();
    private String documentation;

    public void setASTNode(GoloASTNode node) {
        if (node != null) {
            this.nodeRef = new WeakReference<GoloASTNode>(node);
            this.setDocumentationFrom(node);
        }
    }

    public GoloASTNode getASTNode() {
        if (this.nodeRef == null) {
            return null;
        }
        return (GoloASTNode)this.nodeRef.get();
    }

    public boolean hasASTNode() {
        return this.nodeRef != null && this.nodeRef.get() != null;
    }

    public GoloElement ofAST(GoloASTNode node) {
        if (node != null) {
            node.setIrElement(this);
            this.setDocumentationFrom(node);
        }
        return this;
    }

    private void setDocumentationFrom(GoloASTNode node) {
        if (node != null && node.getDocumentation() != null) {
            this.documentation = node.getDocumentation();
        }
    }

    protected void setParentNode(GoloElement parentElement) {
        this.parent = Optional.ofNullable(parentElement);
    }

    public Optional<GoloElement> getParentNode() {
        return this.parent;
    }

    public void makeParentOf(GoloElement childElement) {
        if (childElement != null) {
            childElement.setParentNode(this);
            this.relinkChild(childElement);
        }
    }

    private void relinkChild(GoloElement child) {
        this.getLocalReferenceTable().ifPresent(rt -> child.accept(new AbstractGoloIrVisitor((ReferenceTable)rt){
            boolean prune = true;
            final /* synthetic */ ReferenceTable val$rt;
            {
                this.val$rt = referenceTable;
            }

            @Override
            public void visitBlock(Block b) {
                b.getReferenceTable().relink(this.val$rt, this.prune);
            }

            @Override
            public void visitClosureReference(ClosureReference c) {
                this.prune = false;
                c.walk(this);
            }
        }));
    }

    protected RuntimeException cantReplace() {
        return new UnsupportedOperationException(this.getClass().getName() + " can't replace elements");
    }

    protected RuntimeException cantReplace(GoloElement original, GoloElement replacement) {
        return new IllegalArgumentException(this + " can't replace " + original + " with " + replacement);
    }

    protected RuntimeException doesNotContain(GoloElement element) {
        return new NoSuchElementException(element + " not in " + this);
    }

    protected static RuntimeException cantConvert(String expected, Object value) {
        return new ClassCastException("expecting a " + expected + "but got a " + value.getClass());
    }

    public void replaceInParentBy(GoloElement newElement) {
        if (newElement == this) {
            return;
        }
        if (this.parent.isPresent()) {
            this.parent.get().replaceElement(this, newElement);
            this.parent.get().makeParentOf(newElement);
            if (this.hasASTNode()) {
                this.getASTNode().setIrElement(newElement);
            }
            this.setParentNode(null);
        }
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public PositionInSourceCode getPositionInSourceCode() {
        if (this.hasASTNode()) {
            return this.getASTNode().getPositionInSourceCode();
        }
        return new PositionInSourceCode(0, 0);
    }

    public Optional<ReferenceTable> getLocalReferenceTable() {
        if (this.parent.isPresent()) {
            return this.parent.get().getLocalReferenceTable();
        }
        return Optional.empty();
    }

    public abstract void accept(GoloIrVisitor var1);

    public abstract void walk(GoloIrVisitor var1);

    protected abstract void replaceElement(GoloElement var1, GoloElement var2);
}

