/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.LinkedList;
import org.eclipse.golo.compiler.ir.GoloAssignment;
import org.eclipse.golo.compiler.ir.GoloStatement;

public abstract class ExpressionStatement
extends GoloStatement {
    private final LinkedList<GoloAssignment> declarations = new LinkedList();

    public ExpressionStatement with(Object a) {
        if (!(a instanceof GoloAssignment)) {
            throw new IllegalArgumentException("Must be an assignment, got " + a);
        }
        GoloAssignment declaration = (GoloAssignment)a;
        this.declarations.add(declaration.declaring());
        this.makeParentOf(declaration);
        return this;
    }

    public GoloAssignment[] declarations() {
        return this.declarations.toArray(new GoloAssignment[this.declarations.size()]);
    }

    public boolean hasLocalDeclarations() {
        return !this.declarations.isEmpty();
    }

    public void clearDeclarations() {
        this.declarations.clear();
    }

    public static ExpressionStatement of(Object expr) {
        if (expr instanceof ExpressionStatement) {
            return (ExpressionStatement)expr;
        }
        throw ExpressionStatement.cantConvert("ExpressionStatement", expr);
    }
}

