/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.ir.GoloAssignment;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class DestructuringAssignment
extends GoloAssignment {
    private final List<LocalReference> references = new LinkedList<LocalReference>();
    private boolean isVarargs = false;

    DestructuringAssignment() {
    }

    @Override
    public DestructuringAssignment ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    public DestructuringAssignment varargs(boolean varargs) {
        this.isVarargs = varargs;
        return this;
    }

    public DestructuringAssignment varargs() {
        return this.varargs(true);
    }

    @Override
    public DestructuringAssignment declaring() {
        return this.declaring(true);
    }

    @Override
    public DestructuringAssignment declaring(boolean d) {
        super.declaring(d);
        return this;
    }

    @Override
    public DestructuringAssignment as(Object expr) {
        super.as(expr);
        return this;
    }

    @Override
    public LocalReference[] getReferences() {
        return this.references.toArray(new LocalReference[this.references.size()]);
    }

    @Override
    public int getReferencesCount() {
        return this.references.size();
    }

    @Override
    public DestructuringAssignment to(Object ... refs) {
        for (Object o : refs) {
            if (!(o instanceof LocalReference)) {
                throw new IllegalArgumentException("LocalReference expected, got a " + o.getClass().getName());
            }
            this.references.add((LocalReference)o);
        }
        return this;
    }

    public String toString() {
        LinkedList<String> names = new LinkedList<String>();
        for (LocalReference r : this.getReferences()) {
            names.add(r.toString());
        }
        return String.join((CharSequence)", ", names) + " = " + this.getExpressionStatement().toString();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitDestructuringAssignment(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (LocalReference ref : this.references) {
            ref.accept(visitor);
        }
        super.walk(visitor);
    }
}

