/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.runtime.OperatorType;

public final class BinaryOperation
extends ExpressionStatement {
    private final OperatorType type;
    private ExpressionStatement leftExpression;
    private ExpressionStatement rightExpression;

    BinaryOperation(OperatorType type) {
        this.type = type;
    }

    public static BinaryOperation of(Object type) {
        if (type instanceof OperatorType) {
            return new BinaryOperation((OperatorType)((Object)type));
        }
        if (type instanceof String) {
            return new BinaryOperation(OperatorType.fromString((String)type));
        }
        throw BinaryOperation.cantConvert("BinaryOperation", type);
    }

    public OperatorType getType() {
        return this.type;
    }

    public ExpressionStatement getLeftExpression() {
        return this.leftExpression;
    }

    public BinaryOperation left(Object expr) {
        this.leftExpression = (ExpressionStatement)expr;
        this.makeParentOf(this.leftExpression);
        return this;
    }

    public BinaryOperation right(Object expr) {
        this.rightExpression = (ExpressionStatement)expr;
        this.makeParentOf(this.rightExpression);
        return this;
    }

    public ExpressionStatement getRightExpression() {
        return this.rightExpression;
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{this.leftExpression, this.type, this.rightExpression});
    }

    public boolean isMethodCall() {
        return this.getType() == OperatorType.METHOD_CALL || this.getType() == OperatorType.ELVIS_METHOD_CALL || this.getType() == OperatorType.ANON_CALL;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitBinaryOperation(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.leftExpression.accept(visitor);
        this.rightExpression.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!(newElement instanceof ExpressionStatement)) {
            throw BinaryOperation.cantConvert("ExpressionStatement", newElement);
        }
        if (this.leftExpression.equals(original)) {
            this.left(newElement);
        } else if (this.rightExpression.equals(original)) {
            this.right(newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

