/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.GoloAssignment;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class AssignmentStatement
extends GoloAssignment {
    private LocalReference localReference;

    AssignmentStatement() {
    }

    @Override
    public AssignmentStatement ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    @Override
    public AssignmentStatement declaring() {
        return this.declaring(true);
    }

    @Override
    public AssignmentStatement declaring(boolean isDeclaring) {
        super.declaring(isDeclaring);
        return this;
    }

    public LocalReference getLocalReference() {
        return this.localReference;
    }

    @Override
    public LocalReference[] getReferences() {
        if (this.localReference != null) {
            return new LocalReference[]{this.localReference};
        }
        return new LocalReference[0];
    }

    @Override
    public int getReferencesCount() {
        return this.localReference == null ? 0 : 1;
    }

    @Override
    public AssignmentStatement to(Object ... refs) {
        if (refs.length != 1 || refs[0] == null) {
            throw new IllegalArgumentException("Must assign to one reference");
        }
        this.localReference = (LocalReference)refs[0];
        this.makeParentOf(this.localReference);
        return this;
    }

    @Override
    public AssignmentStatement as(Object expr) {
        super.as(expr);
        return this;
    }

    public String toString() {
        return String.format("%s = %s", this.localReference, this.getExpressionStatement().toString());
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitAssignmentStatement(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        super.walk(visitor);
    }
}

