/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler;

import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.golo.compiler.ir.AbstractGoloIrVisitor;
import org.eclipse.golo.compiler.ir.AssignmentStatement;
import org.eclipse.golo.compiler.ir.Block;
import org.eclipse.golo.compiler.ir.ClosureReference;
import org.eclipse.golo.compiler.ir.FunctionInvocation;
import org.eclipse.golo.compiler.ir.GoloFunction;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.ir.ReferenceLookup;
import org.eclipse.golo.compiler.ir.ReferenceTable;
import org.eclipse.golo.compiler.ir.ThrowStatement;
import org.eclipse.golo.compiler.ir.TryCatchFinally;

public class ClosureCaptureGoloIrVisitor
extends AbstractGoloIrVisitor {
    private final Deque<Context> stack = new LinkedList<Context>();

    private Context context() {
        return this.stack.peek();
    }

    private void newContext() {
        this.stack.push(new Context());
    }

    private void dropContext() {
        this.stack.pop();
    }

    private void dropBlockTable() {
        if (!this.stack.isEmpty()) {
            this.context().referenceTableStack.pop();
        }
    }

    private void pushBlockTable(Block block) {
        if (!this.stack.isEmpty()) {
            if (!this.context().referenceTableStack.isEmpty()) {
                block.getReferenceTable().relink(this.context().referenceTableStack.peek());
            }
            this.context().referenceTableStack.push(block.getReferenceTable());
        }
    }

    private void locallyDeclared(String name) {
        if (!this.stack.isEmpty()) {
            this.context().localReferences.add(name);
        }
    }

    private void locallyAssigned(String name) {
        if (!this.stack.isEmpty()) {
            this.context().accessedReferences.add(name);
        }
    }

    private void accessed(String name) {
        if (!this.stack.isEmpty()) {
            this.context().accessedReferences.add(name);
        }
    }

    private void definedInBlock(Set<String> references, Block block) {
        if (!this.stack.isEmpty()) {
            for (String ref : references) {
                this.context().definingBlock.put(ref, block);
            }
            this.context().allReferences.addAll(references);
        }
    }

    private void declaredParameters(List<String> references) {
        this.context().parameterReferences.addAll(references);
    }

    @Override
    public void visitFunction(GoloFunction function) {
        if (function.isSynthetic()) {
            this.newContext();
            this.declaredParameters(function.getParameterNames());
            function.getBlock().internReferenceTable();
            function.walk(this);
            function.addSyntheticParameters(this.context().shouldBeParameters());
            this.dropUnused(this.context().shouldBeRemoved());
            this.dropContext();
        } else {
            function.walk(this);
        }
        function.captureClosedReference();
    }

    private void dropUnused(Set<String> refs) {
        Context context = this.context();
        for (String ref : refs) {
            if (context.parameterReferences.contains(ref)) continue;
            context.definingBlock.get(ref).getReferenceTable().remove(ref);
        }
    }

    @Override
    public void visitBlock(Block block) {
        this.pushBlockTable(block);
        this.definedInBlock(block.getReferenceTable().ownedSymbols(), block);
        block.walk(this);
        this.dropBlockTable();
    }

    @Override
    public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        if (this.context() != null) {
            Context context = this.context();
            String name = functionInvocation.getName();
            if (context.allReferences.contains(name)) {
                this.accessed(name);
            }
        }
        functionInvocation.walk(this);
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        LocalReference localReference = assignmentStatement.getLocalReference();
        String referenceName = localReference.getName();
        if (!localReference.isModuleState()) {
            if (!this.stack.isEmpty()) {
                assignmentStatement.to(this.context().referenceTableStack.peek().get(referenceName));
            }
            if (assignmentStatement.isDeclaring()) {
                this.locallyDeclared(referenceName);
            }
        } else {
            this.locallyDeclared(referenceName);
        }
        this.locallyAssigned(referenceName);
        assignmentStatement.walk(this);
        if (assignmentStatement.getExpressionStatement() instanceof ClosureReference) {
            ClosureReference closure = (ClosureReference)assignmentStatement.getExpressionStatement();
            closure.getTarget().setSyntheticSelfName(referenceName);
        }
    }

    @Override
    public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        this.accessed(referenceLookup.getName());
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) {
        throwStatement.getExpressionStatement().accept(this);
    }

    @Override
    public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        tryCatchFinally.getTryBlock().accept(this);
        if (tryCatchFinally.hasCatchBlock()) {
            this.locallyAssigned(tryCatchFinally.getExceptionId());
            this.locallyDeclared(tryCatchFinally.getExceptionId());
            tryCatchFinally.getCatchBlock().accept(this);
        }
        if (tryCatchFinally.hasFinallyBlock()) {
            tryCatchFinally.getFinallyBlock().accept(this);
        }
    }

    @Override
    public void visitClosureReference(ClosureReference closureReference) {
        Context context;
        closureReference.walk(this);
        if (closureReference.getTarget().isSynthetic() && (context = this.context()) != null) {
            for (String refName : closureReference.getTarget().getParameterNames()) {
                ReferenceTable referenceTable = context.referenceTableStack.peek();
                if (!referenceTable.hasReferenceFor(refName)) continue;
                this.accessed(refName);
            }
        }
    }

    private static final class Context {
        final Set<String> parameterReferences = new HashSet<String>();
        final Set<String> allReferences = new HashSet<String>();
        final Set<String> localReferences = new HashSet<String>();
        final Set<String> accessedReferences = new HashSet<String>();
        final Map<String, Block> definingBlock = new HashMap<String, Block>();
        final Deque<ReferenceTable> referenceTableStack = new LinkedList<ReferenceTable>();

        private Context() {
        }

        Set<String> shouldBeParameters() {
            HashSet<String> result = new HashSet<String>();
            for (String refName : this.accessedReferences) {
                if (this.localReferences.contains(refName)) continue;
                result.add(refName);
            }
            return result;
        }

        Set<String> shouldBeRemoved() {
            HashSet<String> result = new HashSet<String>(this.allReferences);
            for (String ref : this.accessedReferences) {
                result.remove(ref);
            }
            return result;
        }
    }
}

