/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.cli.command;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class VCS {
    private static final long TIMEOUT = 5L;
    private ProcessBuilder command = new ProcessBuilder(new String[0]).inheritIO();
    private Path ignore;
    private Path destination;
    private List<String> toIgnore = new LinkedList<String>();

    VCS() {
    }

    public VCS command(String ... commands) {
        this.command.command(commands);
        return this;
    }

    public VCS directory(Path dest) {
        this.command.directory(dest.toFile());
        this.destination = dest;
        return this;
    }

    public void init() throws IOException, InterruptedException, InitException {
        this.command.directory().mkdirs();
        Process p = this.command.start();
        if (!p.waitFor(5L, TimeUnit.SECONDS)) {
            p.destroyForcibly();
            throw new InitException(1, "timeout");
        }
        int status = p.exitValue();
        if (status > 0) {
            throw new InitException(status, null);
        }
    }

    public VCS ignoreFilename(String filename) {
        this.ignore = Paths.get(filename, new String[0]);
        return this;
    }

    public Path ignoreFile() {
        return this.ignore;
    }

    public VCS ignore(String ... patterns) {
        for (String p : patterns) {
            this.toIgnore.add(p);
        }
        return this;
    }

    public VCS ignore(Collection<String> patterns) {
        this.toIgnore.addAll(patterns);
        return this;
    }

    public void createIgnoreFile() throws FileNotFoundException, UnsupportedEncodingException, IOException {
        if (this.ignore == null) {
            return;
        }
        Files.createDirectories(this.destination, new FileAttribute[0]);
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.destination.resolve(this.ignore), StandardCharsets.UTF_8, new OpenOption[0]));){
            for (String pattern : this.toIgnore) {
                writer.println(pattern);
            }
        }
    }

    public String toString() {
        return String.format("%s (%s)", this.command.command().get(0), this.command.directory());
    }

    public static final class InitException
    extends Exception {
        private int status;

        InitException(int status, String message) {
            super(message);
            this.status = status;
        }

        int getStatus() {
            return this.status;
        }
    }
}

