/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.Predefined;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public final class IO {
    private IO() {
    }

    public static Charset defaultCharset() {
        return Charset.defaultCharset();
    }

    public static Charset toCharset(Object encoding) {
        if (encoding == null) {
            return IO.defaultCharset();
        }
        Charset charset = null;
        if (encoding instanceof String) {
            charset = Charset.forName((String)encoding);
        } else if (encoding instanceof Charset) {
            charset = (Charset)encoding;
        } else {
            throw new IllegalArgumentException("Can't get a charset from a " + encoding.getClass().getName());
        }
        return charset;
    }

    public static String fileToText(Object file, Object encoding) throws Throwable {
        return new String(Files.readAllBytes(IO.toPath(file)), IO.toCharset(encoding));
    }

    public static Path toPath(Object file) {
        if (file == null) {
            return null;
        }
        if (file instanceof String) {
            return Paths.get((String)file, new String[0]);
        }
        if (file instanceof File) {
            return ((File)file).toPath();
        }
        if (file instanceof Path) {
            return (Path)file;
        }
        throw new IllegalArgumentException("file must be a string, a file or a path");
    }

    public static URL toURL(Object ref) throws MalformedURLException {
        if (ref == null) {
            return null;
        }
        if (ref instanceof String) {
            return new URL((String)ref);
        }
        if (ref instanceof URL) {
            return (URL)ref;
        }
        if (ref instanceof URI) {
            return ((URI)ref).toURL();
        }
        if (ref instanceof Path) {
            return ((Path)ref).toUri().toURL();
        }
        if (ref instanceof File) {
            return ((File)ref).toURI().toURL();
        }
        throw new IllegalArgumentException(String.format("Can't convert a %s into a URL", ref.getClass().getName()));
    }

    public static void textToFile(Object text, Object file) throws Throwable {
        IO.textToFile(text, file, null);
    }

    public static void textToFile(Object text, Object file, Object charset) throws Throwable {
        Predefined.require(text instanceof String, "text must be a string");
        Charset encoding = IO.toCharset(charset);
        String str = (String)text;
        if ("-".equals(file.toString())) {
            System.out.write(str.getBytes(encoding));
        } else {
            Path path = IO.toPath(file);
            if (path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.write(path, str.getBytes(encoding), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public static boolean fileExists(Object file) {
        return Files.exists(IO.toPath(file), new LinkOption[0]);
    }

    public static String readln() throws IOException {
        return System.console().readLine();
    }

    public static String readln(String message) throws IOException {
        System.out.print(message);
        return IO.readln();
    }

    public static String readPassword() throws IOException {
        return String.valueOf(System.console().readPassword());
    }

    public static String readPassword(String message) throws IOException {
        System.out.print(message);
        return IO.readPassword();
    }

    public static char[] secureReadPassword() throws IOException {
        return System.console().readPassword();
    }

    public static char[] secureReadPassword(String message) throws IOException {
        System.out.print(message);
        return IO.secureReadPassword();
    }

    public static PrintStream printStreamFrom(Object output) throws IOException {
        return IO.printStreamFrom(output, IO.defaultCharset());
    }

    public static PrintStream printStreamFrom(Object output, Object charset) throws IOException {
        OutputStream out;
        if ("-".equals(output)) {
            return System.out;
        }
        if (output instanceof PrintStream) {
            return (PrintStream)output;
        }
        if (output instanceof OutputStream) {
            out = (OutputStream)output;
        } else {
            Path outputPath = IO.toPath(output);
            if (outputPath.getParent() != null) {
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            }
            out = Files.newOutputStream(outputPath, new OpenOption[0]);
        }
        return new PrintStream((OutputStream)new BufferedOutputStream(out), true, IO.toCharset(charset).name());
    }
}

