/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.Predefined;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.golo.runtime.DecoratorsHelper;

public final class TypeMatching {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_MAP = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Character.TYPE, Character.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
            this.put(Boolean.TYPE, Boolean.class);
        }
    };

    private TypeMatching() {
        throw new UnsupportedOperationException("Don't instantiate utility classes");
    }

    public static boolean canAssign(Class<?>[] types2, Object[] arguments, boolean varArgs) {
        if (types2.length == 0 || arguments.length == 0) {
            return true;
        }
        for (int i = 0; i < types2.length - 1; ++i) {
            if (TypeMatching.valueAndTypeMatch(types2[i], arguments[i])) continue;
            return false;
        }
        int last = types2.length - 1;
        if (varArgs && arguments.length == last) {
            return true;
        }
        if (last >= arguments.length) {
            return false;
        }
        if (varArgs && !(arguments[last] instanceof Object[])) {
            return TypeMatching.valueAndTypeMatch(types2[last].getComponentType(), arguments[last]);
        }
        return TypeMatching.valueAndTypeMatch(types2[last], arguments[last]);
    }

    private static boolean valueAndTypeMatch(Class<?> type, Object value) {
        if (type == null) {
            return false;
        }
        return TypeMatching.primitiveCompatible(type, value) || type.isInstance(value) || value == null || TypeMatching.samAssignment(type, value) || TypeMatching.functionalInterfaceAssignment(type, value);
    }

    public static boolean functionalInterfaceAssignment(Class<?> type, Object value) {
        return Predefined.isClosure(value) && TypeMatching.isFunctionalInterface(type);
    }

    public static boolean samAssignment(Class<?> type, Object value) {
        return Predefined.isClosure(value) && TypeMatching.isSAM(type);
    }

    public static boolean isSAM(Class<?> type) {
        return type.isInterface() && type.getMethods().length == 1;
    }

    public static boolean isFunctionalInterface(Class<?> type) {
        return type.isAnnotationPresent(FunctionalInterface.class);
    }

    private static boolean primitiveCompatible(Class<?> type, Object value) {
        if (!type.isPrimitive() || value == null) {
            return false;
        }
        return PRIMITIVE_MAP.get(type) == value.getClass();
    }

    public static boolean isLastArgumentAnArray(int index, Object[] args) {
        return index > 0 && args.length == index && args[index - 1] instanceof Object[];
    }

    public static boolean argumentsNumberMatches(int paramsNumber, int argsNumber, boolean isVarArgs) {
        return argsNumber < 0 || !isVarArgs && paramsNumber == argsNumber || isVarArgs && argsNumber >= paramsNumber - 1;
    }

    public static boolean argumentsMatch(Method method, Object[] arguments) {
        return TypeMatching.argumentsMatch(method, arguments, method.isVarArgs());
    }

    public static boolean argumentsMatch(Method method, Object[] arguments, boolean varargs) {
        Object[] args = Modifier.isStatic(method.getModifiers()) ? arguments : Arrays.copyOfRange(arguments, 1, arguments.length);
        return DecoratorsHelper.isMethodDecorated(method) || TypeMatching.argumentsNumberMatches(method.getParameterCount(), args.length, varargs) && TypeMatching.canAssign(method.getParameterTypes(), args, varargs);
    }

    public static boolean argumentsMatch(Constructor<?> constructor, Object[] arguments) {
        return TypeMatching.argumentsNumberMatches(constructor.getParameterCount(), arguments.length, constructor.isVarArgs()) && TypeMatching.canAssign(constructor.getParameterTypes(), arguments, constructor.isVarArgs());
    }

    public static boolean returnsValue(Method m) {
        return !m.getReturnType().equals(Void.TYPE) && !m.getReturnType().equals(Void.class);
    }
}

