/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.eclipse.golo.runtime.TypeMatching;

public class MethodInvocation {
    private final String name;
    private final Class<?> receiverClass;
    private final Object[] arguments;
    private final int arity;
    private final String[] argumentNames;
    private final MethodType type;

    MethodInvocation(String name, MethodType type, Object[] args, String[] argNames) {
        this.name = name;
        this.receiverClass = args[0].getClass();
        this.arguments = args;
        this.arity = args.length;
        this.type = type;
        this.argumentNames = argNames;
    }

    public String name() {
        return this.name;
    }

    public Class<?> receiverClass() {
        return this.receiverClass;
    }

    public Object[] arguments() {
        return this.arguments;
    }

    public int arity() {
        return this.arity;
    }

    public String[] argumentNames() {
        return this.argumentNames;
    }

    public MethodType type() {
        return this.type;
    }

    private boolean isLastArgumentAnArray() {
        return this.arity > 0 && this.arguments.length == this.arity && this.arguments[this.arity - 1] instanceof Object[];
    }

    public MethodHandle coerce(MethodHandle target) {
        if (target.isVarargsCollector() && this.isLastArgumentAnArray()) {
            return target.asFixedArity().asType(this.type);
        }
        return target.asType(this.type);
    }

    public boolean match(Method method) {
        return method.getName().equals(this.name) && Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers()) && TypeMatching.argumentsMatch(method, this.arguments);
    }

    MethodInvocation withName(String newName) {
        return new MethodInvocation(newName, this.type, this.arguments, this.argumentNames);
    }

    public String toString() {
        return this.name + this.type + Arrays.asList(this.arguments);
    }
}

