/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.MemberDocumentation;
import org.eclipse.golo.doc.MemberHolder;

class StructDocumentation
implements DocumentationElement,
MemberHolder {
    private String name;
    private String documentation;
    private int line;
    private List<MemberDocumentation> members = new LinkedList<MemberDocumentation>();
    private DocumentationElement parent;

    StructDocumentation() {
    }

    @Override
    public String type() {
        return "struct";
    }

    @Override
    public String name() {
        return this.name;
    }

    public StructDocumentation name(String n) {
        this.name = n;
        return this;
    }

    @Override
    public DocumentationElement parent() {
        return this.parent;
    }

    public StructDocumentation parent(DocumentationElement p) {
        this.parent = p;
        return this;
    }

    @Override
    public String documentation() {
        return this.documentation != null ? this.documentation : "\n";
    }

    public StructDocumentation documentation(String doc) {
        this.documentation = doc;
        return this;
    }

    @Override
    public int line() {
        return this.line;
    }

    public StructDocumentation line(int l) {
        this.line = l;
        return this;
    }

    @Override
    public List<MemberDocumentation> members() {
        return Collections.unmodifiableList(this.members);
    }

    @Override
    public StructDocumentation members(Collection<MemberDocumentation> m) {
        this.members.addAll(m);
        return this;
    }

    @Override
    public MemberDocumentation addMember(String name) {
        MemberDocumentation doc = new MemberDocumentation().name(name);
        this.members.add(doc);
        return doc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructDocumentation)) {
            return false;
        }
        StructDocumentation that = (StructDocumentation)o;
        return this.name.equals(that.name) && this.members.equals(that.members);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.members);
    }
}

