/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

interface DocumentationElement
extends Comparable<DocumentationElement> {
    public String name();

    public String documentation();

    public int line();

    public DocumentationElement parent();

    public String type();

    default public String fullName() {
        return this.parent().fullName() + "." + this.name();
    }

    default public String id() {
        if (this.parent() != null && !this.parent().id().isEmpty()) {
            return this.parent().id() + '.' + this.name();
        }
        return this.name();
    }

    default public String label() {
        return this.name();
    }

    @Override
    default public int compareTo(DocumentationElement other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int c = this.label().compareToIgnoreCase(other.label());
        if (c == 0) {
            c = this.type().compareTo(other.type());
        }
        if (c == 0 && this.parent() != this) {
            c = this.parent().compareTo(other.parent());
        }
        return c;
    }
}

