/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.compiler.ir.Alternatives;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.WhenClause;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class MatchExpression
extends ExpressionStatement
implements Alternatives<ExpressionStatement> {
    private ExpressionStatement otherwise;
    private final LinkedList<WhenClause<ExpressionStatement>> clauses = new LinkedList();

    MatchExpression() {
    }

    public MatchExpression when(Object cond) {
        WhenClause<Object> clause = new WhenClause<Object>(ExpressionStatement.of(cond), null);
        this.clauses.add(clause);
        this.makeParentOf(clause);
        return this;
    }

    public MatchExpression then(Object action) {
        this.clauses.getLast().setAction((ExpressionStatement)action);
        return this;
    }

    public MatchExpression otherwise(Object action) {
        this.otherwise = (ExpressionStatement)action;
        this.makeParentOf(this.otherwise);
        return this;
    }

    @Override
    public List<WhenClause<ExpressionStatement>> getClauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    @Override
    public ExpressionStatement getOtherwise() {
        return this.otherwise;
    }

    @Override
    public MatchExpression ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitMatchExpression(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (WhenClause whenClause : this.clauses) {
            whenClause.accept(visitor);
        }
        this.otherwise.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!(newElement instanceof ExpressionStatement) && !(newElement instanceof WhenClause)) {
            throw MatchExpression.cantConvert("ExpressionStatement or WhenClause", newElement);
        }
        if (this.otherwise.equals(original)) {
            this.otherwise(newElement);
            return;
        }
        if (this.clauses.contains(original)) {
            WhenClause when = (WhenClause)newElement;
            this.clauses.set(this.clauses.indexOf(original), when);
            this.makeParentOf(when);
            return;
        }
        throw this.doesNotContain(original);
    }
}

