/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class DestructuringAssignment
extends GoloStatement {
    private final List<LocalReference> references = new LinkedList<LocalReference>();
    private boolean isVarargs = false;
    private boolean isDeclaring = false;
    private ExpressionStatement expression;

    DestructuringAssignment() {
    }

    @Override
    public DestructuringAssignment ofAST(GoloASTNode n) {
        super.ofAST(n);
        return this;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    public DestructuringAssignment varargs(boolean varargs) {
        this.isVarargs = varargs;
        return this;
    }

    public DestructuringAssignment varargs() {
        return this.varargs(true);
    }

    public DestructuringAssignment declaring() {
        return this.declaring(true);
    }

    public DestructuringAssignment declaring(boolean d) {
        this.isDeclaring = d;
        return this;
    }

    public boolean isDeclaring() {
        return this.isDeclaring;
    }

    public ExpressionStatement getExpression() {
        return this.expression;
    }

    public DestructuringAssignment expression(Object expr) {
        this.expression = ExpressionStatement.of(expr);
        this.makeParentOf(this.expression);
        return this;
    }

    public List<LocalReference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public DestructuringAssignment to(Object var) {
        Objects.requireNonNull(var);
        if (var instanceof Iterable) {
            for (Object o : (Iterable)var) {
                this.to(o);
            }
        } else if (var instanceof LocalReference) {
            this.references.add((LocalReference)var);
        } else {
            throw new IllegalArgumentException("LocalReference expected, got a " + var.getClass());
        }
        return this;
    }

    public String toString() {
        LinkedList<String> names = new LinkedList<String>();
        for (LocalReference r : this.getReferences()) {
            names.add(r.toString());
        }
        return String.join((CharSequence)", ", names) + " = " + this.getExpression().toString();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitDestructuringAssignment(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        for (LocalReference ref : this.references) {
            ref.accept(visitor);
        }
        this.expression.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (this.expression != original || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.expression(newElement);
    }
}

