/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.compiler.ir;

import org.eclipse.golo.compiler.ir.ExpressionStatement;
import org.eclipse.golo.compiler.ir.GoloElement;
import org.eclipse.golo.compiler.ir.GoloIrVisitor;
import org.eclipse.golo.compiler.ir.GoloStatement;
import org.eclipse.golo.compiler.ir.LocalReference;
import org.eclipse.golo.compiler.parser.GoloASTNode;

public final class AssignmentStatement
extends GoloStatement {
    private LocalReference localReference;
    private ExpressionStatement expressionStatement;
    private boolean declaring = false;

    AssignmentStatement() {
    }

    @Override
    public AssignmentStatement ofAST(GoloASTNode node) {
        super.ofAST(node);
        return this;
    }

    public boolean isDeclaring() {
        return this.declaring;
    }

    public AssignmentStatement declaring() {
        return this.declaring(true);
    }

    public AssignmentStatement declaring(boolean isDeclaring) {
        this.declaring = isDeclaring;
        return this;
    }

    public LocalReference getLocalReference() {
        return this.localReference;
    }

    public AssignmentStatement to(Object ref) {
        this.localReference = (LocalReference)ref;
        this.makeParentOf(this.localReference);
        return this;
    }

    public ExpressionStatement getExpressionStatement() {
        return this.expressionStatement;
    }

    public AssignmentStatement as(Object expr) {
        this.expressionStatement = (ExpressionStatement)expr;
        this.makeParentOf(this.expressionStatement);
        return this;
    }

    public String toString() {
        return String.format("%s = %s", this.localReference, this.expressionStatement);
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitAssignmentStatement(this);
    }

    @Override
    public void walk(GoloIrVisitor visitor) {
        this.expressionStatement.accept(visitor);
    }

    @Override
    protected void replaceElement(GoloElement original, GoloElement newElement) {
        if (!original.equals(this.expressionStatement) || !(newElement instanceof ExpressionStatement)) {
            throw this.cantReplace(original, newElement);
        }
        this.as(newElement);
    }
}

