/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.golo.compiler.GoloClassLoader;
import org.eclipse.golo.compiler.GoloCompilationException;

public class EvaluationEnvironment {
    private final GoloClassLoader goloClassLoader;
    private final List<String> imports = new LinkedList<String>();

    private static String anonymousFilename() {
        return "$Anonymous$_" + System.nanoTime() + ".golo";
    }

    private static String anonymousModuleName() {
        return "module anonymous" + System.nanoTime();
    }

    public EvaluationEnvironment() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public EvaluationEnvironment(ClassLoader parentClassLoader) {
        this.goloClassLoader = new GoloClassLoader(parentClassLoader);
    }

    public EvaluationEnvironment imports(String head, String ... tail) {
        this.imports.add(head);
        Collections.addAll(this.imports, tail);
        return this;
    }

    public EvaluationEnvironment clearImports() {
        this.imports.clear();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object asModule(String source) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8));){
            Class<?> clazz = this.goloClassLoader.load(EvaluationEnvironment.anonymousFilename(), in);
            return clazz;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (GoloCompilationException e) {
            e.setSourceCode(source);
            throw e;
        }
    }

    public Object anonymousModule(String source) {
        return this.asModule(EvaluationEnvironment.anonymousModuleName() + "\n\n" + source);
    }

    public Object def(String source) {
        return this.loadAndRun("return " + source, "$_code", new String[0]);
    }

    public Object asFunction(String source, String ... argumentNames) {
        return this.loadAndRun(source, "$_code_ref", argumentNames);
    }

    public Object run(String source) {
        return this.loadAndRun(source, "$_code", new String[0]);
    }

    public Object run(String source, Map<String, Object> context) {
        StringBuilder builder = new StringBuilder();
        for (String param : context.keySet()) {
            builder.append("let ").append(param).append(" = $_env: get(\"").append(param).append("\")\n");
        }
        builder.append(source);
        return this.loadAndRun(builder.toString(), "$_code", new String[]{"$_env"}, new Object[]{context});
    }

    private Class<?> wrapAndLoad(String source, String ... argumentNames) {
        StringBuilder builder = new StringBuilder().append(EvaluationEnvironment.anonymousModuleName()).append("\n");
        for (String importSymbol : this.imports) {
            builder.append("import ").append(importSymbol).append("\n");
        }
        builder.append("\nfunction $_code = ");
        if (argumentNames.length > 0) {
            builder.append("| ");
            int lastIndex = argumentNames.length - 1;
            for (int i = 0; i < argumentNames.length; ++i) {
                builder.append(argumentNames[i]);
                if (i >= lastIndex) continue;
                builder.append(", ");
            }
            builder.append(" |");
        }
        builder.append(" {\n").append(source).append("\n}\n\n").append("function $_code_ref = -> ^$_code\n\n");
        return (Class)this.asModule(builder.toString());
    }

    private Object loadAndRun(String source, String target, String ... argumentNames) {
        try {
            Class<?> module = this.wrapAndLoad(source, argumentNames);
            return module.getMethod(target, new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object loadAndRun(String source, String target, String[] argumentNames, Object[] arguments) {
        try {
            Class<?> module = this.wrapAndLoad(source, argumentNames);
            Object[] type = new Class[argumentNames.length];
            Arrays.fill(type, Object.class);
            return module.getMethod(target, (Class<?>[])type).invoke(null, arguments);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

