/*
 * Decompiled with CFR 0.152.
 */
package gololang;

import gololang.FunctionReference;
import gololang.Predefined;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DynamicObject {
    private final Object kind;
    private final HashMap<String, Object> properties = new HashMap();
    private boolean frozen = false;
    public static final MethodHandle DISPATCH_CALL;
    public static final MethodHandle DISPATCH_GET;
    public static final MethodHandle DISPATCH_SET;
    public static final MethodHandle DISPATCH_DELEGATE;

    public DynamicObject() {
        this("DynamicObject");
    }

    public DynamicObject(Object kind) {
        this.kind = kind;
    }

    public boolean hasKind(Object k) {
        return Objects.equals(this.kind, k);
    }

    public boolean sameKind(DynamicObject other) {
        return Objects.equals(this.kind, other.kind);
    }

    public String toString() {
        LinkedList<String> props = new LinkedList<String>();
        for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
            if (Predefined.isClosure(prop.getValue())) continue;
            props.add(String.format("%s=%s", prop.getKey(), prop.getValue().toString()));
        }
        return String.format("%s{%s}", this.kind, String.join((CharSequence)", ", props));
    }

    public DynamicObject define(String name, Object value) {
        this.frozenMutationCheck();
        this.properties.put(name, value);
        return this;
    }

    public Set<Map.Entry<String, Object>> properties() {
        return this.properties.entrySet();
    }

    public Object get(String name) {
        return this.properties.get(name);
    }

    public DynamicObject undefine(String name) {
        this.properties.remove(name);
        return this;
    }

    public DynamicObject copy() {
        DynamicObject copy = new DynamicObject(this.kind);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            copy.properties.put(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public DynamicObject mixin(DynamicObject other) {
        this.frozenMutationCheck();
        for (Map.Entry<String, Object> entry : other.properties.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public DynamicObject freeze() {
        this.frozen = true;
        return this;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public static Object dispatchCall(String property, Object ... args) throws Throwable {
        DynamicObject obj = (DynamicObject)args[0];
        Object value = obj.properties.get(property);
        if (value != null) {
            if (value instanceof FunctionReference) {
                FunctionReference funRef = (FunctionReference)value;
                if (funRef.isVarargsCollector() && args[args.length - 1] instanceof Object[]) {
                    return funRef.spread(args);
                }
                return funRef.invoke(args);
            }
            throw new UnsupportedOperationException("There is no dynamic object method defined for " + property);
        }
        if (obj.hasFallback()) {
            FunctionReference handle = (FunctionReference)obj.properties.get("fallback");
            Object[] fallback_args = new Object[args.length + 1];
            fallback_args[0] = obj;
            fallback_args[1] = property;
            System.arraycopy(args, 1, fallback_args, 2, args.length - 1);
            return handle.invoke(fallback_args);
        }
        throw new UnsupportedOperationException("There is neither a dynamic object method defined for " + property + " nor a 'fallback' method");
    }

    public static Object dispatchGetterStyle(String property, DynamicObject object) throws Throwable {
        Object value = object.get(property);
        if (value != null || object.properties.containsKey(property)) {
            FunctionReference funRef;
            if (value instanceof FunctionReference && (funRef = (FunctionReference)value).acceptArity(1)) {
                return funRef.invoke(object);
            }
            return value;
        }
        if (object.hasFallback()) {
            FunctionReference funRef = (FunctionReference)object.properties.get("fallback");
            return funRef.invoke(object, property);
        }
        return null;
    }

    public static Object dispatchSetterStyle(String property, DynamicObject object, Object arg) throws Throwable {
        FunctionReference funRef;
        Object value = object.get(property);
        if ((value != null || object.properties.containsKey(property)) && value instanceof FunctionReference && (funRef = (FunctionReference)value).arity() == 2) {
            if (funRef.isVarargsCollector() && arg instanceof Object[]) {
                return funRef.handle().invokeExact(object, (Object[])arg);
            }
            return funRef.invoke(object, arg);
        }
        return object.define(property, arg);
    }

    public static Object dispatchDelegate(DynamicObject deleguee, DynamicObject receiver, String property, Object ... args) throws Throwable {
        return deleguee.invoker(property, MethodType.genericMethodType(args.length + 1)).bindTo(deleguee).invokeWithArguments(args);
    }

    public static FunctionReference delegate(DynamicObject deleguee) {
        return new FunctionReference(DISPATCH_DELEGATE.bindTo(deleguee).asVarargsCollector(Object[].class), new String[]{"this", "name", "args"});
    }

    public MethodHandle invoker(String property, MethodType type) {
        switch (type.parameterCount()) {
            case 0: {
                throw new IllegalArgumentException("A dynamic object invoker type needs at least 1 argument (the receiver)");
            }
            case 1: {
                return DISPATCH_GET.bindTo(property).asType(MethodType.genericMethodType(1));
            }
            case 2: {
                return DISPATCH_SET.bindTo(property).asType(MethodType.genericMethodType(2));
            }
        }
        return DISPATCH_CALL.bindTo(property).asCollector(Object[].class, type.parameterCount());
    }

    public boolean hasMethod(String method) {
        Object obj = this.properties.get(method);
        if (obj != null) {
            return Predefined.isClosure(obj);
        }
        return false;
    }

    public DynamicObject fallback(Object value) {
        return this.define("fallback", value);
    }

    private boolean hasFallback() {
        return this.properties.containsKey("fallback");
    }

    private void frozenMutationCheck() {
        if (this.frozen) {
            throw new IllegalStateException("the object is frozen");
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            DISPATCH_DELEGATE = lookup.findStatic(DynamicObject.class, "dispatchDelegate", MethodType.methodType(Object.class, DynamicObject.class, DynamicObject.class, String.class, Object[].class));
            DISPATCH_CALL = lookup.findStatic(DynamicObject.class, "dispatchCall", MethodType.methodType(Object.class, String.class, Object[].class));
            DISPATCH_GET = lookup.findStatic(DynamicObject.class, "dispatchGetterStyle", MethodType.methodType(Object.class, String.class, DynamicObject.class));
            DISPATCH_SET = lookup.findStatic(DynamicObject.class, "dispatchSetterStyle", MethodType.methodType(Object.class, String.class, DynamicObject.class, Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
            throw new Error("Could not bootstrap the required method handles");
        }
    }
}

