/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.util.HashMap;

public enum OperatorType {
    PLUS("+"),
    MINUS("-"),
    TIMES("*"),
    DIVIDE("/"),
    MODULO("%"),
    EQUALS("=="),
    NOTEQUALS("!="),
    LESS("<"),
    LESSOREQUALS("<="),
    MORE(">"),
    MOREOREQUALS(">="),
    AND("and"),
    OR("or"),
    NOT("not"),
    IS("is"),
    ISNT("isnt"),
    OFTYPE("oftype"),
    ORIFNULL("orIfNull"),
    ANON_CALL(""),
    METHOD_CALL(":"),
    ELVIS_METHOD_CALL("?:");

    private final String symbol;
    private static final HashMap<String, OperatorType> SYMBOL_MAPPING;

    private OperatorType(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public static OperatorType fromString(String symbol) {
        if (!SYMBOL_MAPPING.containsKey(symbol)) {
            throw new IllegalArgumentException("Unknown symbol for OperatorType: " + symbol);
        }
        return SYMBOL_MAPPING.get(symbol);
    }

    static {
        SYMBOL_MAPPING = new HashMap();
        for (OperatorType op : OperatorType.values()) {
            SYMBOL_MAPPING.put(op.toString(), op);
        }
    }
}

